#!/bin/sh

# Update.sh APP=update.tgz RFS=update.img MCM=update.hex

PARM_01=${1}
PARM_02=${2}
PARM_03=${3}
PARM_04=${4}

function CheckPartition()
{
	echo "Check Partition"
	dd if=/dev/mtd9 of=/partition1 skip=64 bs=2048 count=1
	dd if=/dev/mtd9 of=/partition2 skip=128 bs=2048 count=1
	VERSION1_VALID=`cat /partition1 | grep DST | wc -l`
	VERSION2_VALID=`cat /partition2 | grep DST | wc -l`
	VERSION1=`cat /partition1 | grep DST | awk '{print $2}' | awk -F= '{print $2}'`
	VERSION2=`cat /partition2 | grep DST | awk '{print $2}' | awk -F= '{print $2}'`
	KERNEL1=`cat /partition1 | grep DST | awk '{print $3}' | awk -F= '{print $2}'`
	KERNEL2=`cat /partition2 | grep DST | awk '{print $3}' | awk -F= '{print $2}'`
	APP1=`cat /partition1 | grep DST | awk '{print $4}' | awk -F= '{print $2}'`
	APP2=`cat /partition2 | grep DST | awk '{print $4}' | awk -F= '{print $2}'`
	VERSION=0

	if [ $VERSION1_VALID -eq 0 ]; then
		NEW_PT=1
	
	else 
		if [ $VERSION2_VALID == 0 ]; then
			NEW_PT=2
		else
			if [ $VERSION1 -ge $VERSION2 ]; then
				if [ $VERSION1 -eq 19 ]; then
					if [ $VERSION2 -eq 0 ]; then
						NEW_PT=1
					else
						NEW_PT=2		
					fi
				
				else			
					NEW_PT=2
				fi
			else	
				if [ $VERSION2 -eq 19 ]; then
					if [ $VERSION1 -eq 0 ]; then
						NEW_PT=2
					else
						NEW_PT=1		
					fi
				
				else			
					NEW_PT=1
				fi
			fi
		fi
	fi
	
	if [ $NEW_PT -eq 1 ]; then
		if [ $VERSION2_VALID -eq 0 ]; then
			KERNEL_PT=3
			APP_PT=7
			VERSION=0
			return
		else
			KERNEL_PT=$KERNEL2
			APP_PT=$APP2
			((VERSION+=VERSION2))
		fi
	else
		if [ $VERSION1_VALID -eq 0 ]; then
			KERNEL_PT=3
			APP_PT=7
			VERSION=0
			return
		else
			KERNEL_PT=$KERNEL1
			APP_PT=$APP1
			((VERSION+=VERSION1))
		fi
	fi
	
	
	if [ ! -z "$UPDATE_RFS_FILE" ]; then
		if [ $KERNEL_PT == 4 ]; then
			KERNEL_PT=3
		else
			KERNEL_PT=4
		fi
	fi

	if [ ! -z "$UPDATE_APP_FILE" ]; then
		if [ $APP_PT == 7 ]; then
			APP_PT=8
		else
			APP_PT=7
		fi
	fi
	if [ $VERSION -eq 19 ]; then
		VERSION=0
	else
		((VERSION+=1))
	fi
	
}
function EraseInformation()
{
	if [ $NEW_PT == 1 ]; then
		erase /dev/mtd9 131072 1
	else
		erase /dev/mtd9 262144 1
	fi
}

function SaveInformation()
{
	if [ $VERSION -eq 20 ]; then
		VERSION=0
	fi

	echo "APP Partition = $1"
	echo "DST VERSION="$VERSION" KERNEL="$KERNEL_PT" APP="$1"" >> /new_info
	if [ $NEW_PT == 1 ]; then
		erase /dev/mtd9 131072 1
		dd if=/new_info of=/dev/mtdblock9 seek=64 bs=2048 count=1
	else
		erase /dev/mtd9 262144 1
		dd if=/new_info of=/dev/mtdblock9 seek=128 bs=2048 count=1
	fi

}
function ParseArgs()
{
	if [ ! $PARM_04 == 0 ]; then 
		echo " Too many execced argumnet value "
	 	return 	
	fi	
	
	for NUM in $PARM_01 $PARM_02 $PARM_03 
	do
		PARMNUM=$NUM
		if [ ! "$PARM_$NUM" == ${PARMNUM##APP=} ]; then 
			UPDATE_APP_FILE=${PARMNUM##APP=}
			echo "UPDATE_APP_FILE=$UPDATE_APP_FILE"
		fi
		
		if [ ! "$PARM_$NUM" == ${PARMNUM##RFS=} ]; then
			UPDATE_RFS_FILE=${PARMNUM##RFS=}
			echo "UPDATE_RFS_FILE=$UPDATE_RFS_FILE"
		fi

		if [ ! "$PARM_$NUM" == ${PARMNUM##MCM=} ]; then
			UPDATE_MCM_FILE=${PARMNUM##MCM=}
			echo "UPDATE_MCM_FILE=$UPDATE_MCM_FILE"
		fi
	done
}

function GetInactiveRoot()
{
    count=`cat /proc/mounts | grep mtdblock | grep cramfs | wc -c`
    if [ "$count" = "0" ]; then
        RET=-1
        return
    fi
    InactiveNum=`cat /proc/mounts | grep mtdblock | grep cramfs | awk '{print $1}' | awk -F"mtdblockr" '{print $2}'`
    
    if [ "$InactiveNum" != "7" ] && [ "$InactiveNum" != "8" ]; then
        RET=-1
        return
    else
        if [ "$InactiveNum" = "7" ]; then
            InactiveNum=8
        else
            InactiveNum=7
        fi
    fi
    
    RET=$InactiveNum
    echo "PARTITION : $RET"
}
    
function SetEnv()
{
	DB_FILE=Red.db
	APP_ROOT=/mnt/flash
	APP_DEVICE_NUM=$1
	APP_RAW_DEVICE=/dev/mtd$1
	APP_DEVICE=/dev/mtdblock$1 
	USER_RAW_DEVICE=/dev/mtd9
	USER_DATA_FILE=/dummy
	BIN=Bin
	LIB=Lib
	RESOURCE=Resource
	RC_USER=rc.user
}

function UpdateMagicKey()
{
    erase $USER_RAW_DEVICE 0 1
    if [ "$APP_DEVICE_NUM" = "7" ]; then
        DISKID="0000"
        MD5SUM="c0f5cc61f38fabd189e2c6ac523d75c6"
    else
        DISKID="0001"
        MD5SUM="882b047bd9e71209a2f1f2d0c6730084"
    fi
    echo "VALD"$DISKID$MD5SUM > $USER_DATA_FILE
    dd if=/dev/zero of=$USER_DATA_FILE seek=40 bs=2008 count=1
    dd if=$USER_DATA_FILE of=$USER_RAW_DEVICE bs=2048 count=1
}

function BackupResource()
{
	echo "backup resource"
	# backup configuration files
    # We don't need to update DB. (Junku/100115)
	#cp -f $APP_ROOT/$RESOURCE/*.conf /$RESOURCE/
	# restore db
	#cp -f $APP_ROOT/$RESOURCE/$DB_FILE /$RESOURCE/
}

function RestoreResource()
{
	echo "restore user data"
	# restore configuration files
	#cp -f /$RESOURCE/*.conf $APP_ROOT/$RESOURCE/
	# restore db
	#cp -f /$RESOURCE/$DB_FILE $APP_ROOT/$RESOURCE/
}

function SendProgress
{
#$1: amount to increase
	((PROGRESS += $1))
	PROGRESS_EVENT_ID=1010
	echo "EventNotifier $LOCAL_HOST $PROGRESS_EVENT_ID $PROGRESS"
	/Bin/EventNotifier $LOCAL_HOST $PROGRESS_EVENT_ID $PROGRESS
}

function ExitEmergency()
{
	EXIT_EVENT_ID=3
	/Bin/EventNotifier $LOCAL_HOST $EXIT_EVENT_ID
}

function DeleteAppData()
{
	echo "delete old data"
	cd # /root
	#umount $APP_ROOT
	flash_eraseall $APP_RAW_DEVICE
	#sleep 1
	#mount -t yaffs $APP_DEVICE $APP_ROOT
}

function UpdateApp()
{
	echo "start update app"

	if [ ! -f $UPDATE_APP_FILE ]; then
		echo "invalid kernel/RFS update file"
		return
	fi

	BackupResource
	DeleteAppData 

	SendProgress 10

	echo "install new data with nandwrite"
	#tar xvzf $UPDATE_APP_FILE -C $APP_ROOT
	nandwrite -p $APP_RAW_DEVICE $UPDATE_APP_FILE 
#	dd if=$UPDATE_APP_FILE of=$APP_RAW_DEVICE bs=2048

	SendProgress 40

    UpdateMagicKey
	RestoreResource
	
	SendProgress 10
	
	echo "update app successfully"
}

function UpdateRfs()
{
	echo "start update kernel/RFS"
	EraseInformation	
	if [ ! -f $UPDATE_RFS_FILE ]; then
		echo "invalid kernel/RFS update file"
		return
	fi
	
	RFS_RAW_DEVICE=/dev/mtd$KERNEL_PT
	flash_eraseall $RFS_RAW_DEVICE
	SendProgress 20
	nandwrite $RFS_RAW_DEVICE $UPDATE_RFS_FILE -p
	if [ $? -eq 0 ]; then
		SaveInformation $RET
	fi
	
}

function UpdateMicom()
{
	if [ ! -f $UPDATE_MCM_FILE ]; then
		echo "invalid micom update file"
		return
	fi
	
	echo "start update micom"

	/Bin/UpdateMicom $UPDATE_MCM_FILE 
	sleep 1

	echo "update micom successfully"
	SendProgress 20
}

###########################################
# main

function PrintUsage()
{
	echo "Usage: `basename $0` APP=update.tgz RFS=update.img MCM=update.hex"
}

if [ $# == 0 ]; then
	PrintUsage
	exit 0
fi

ParseArgs
GetInactiveRoot
if [ ! -z "$UPDATE_APP_FILE" ] && [ "$RET" = "-1" ]; then
    echo "cannot find valid cramfs partition: burn it on mtd7."
    #exit 1
    RET=7
fi

SetEnv $RET

LOCAL_HOST=127.0.0.1
SendProgress 0

rm /partition* -rf
rm /new_info* -rf
CheckPartition

if [ ! -z "$UPDATE_APP_FILE" ]; then
	UpdateApp
fi

if [ ! -z "$UPDATE_RFS_FILE" ]; then
	UpdateRfs
fi

if [ ! -z "$UPDATE_MCM_FILE" ]; then
	UpdateMicom
fi


#sleep 1
#ExitEmergency

echo "update has been completed"
