#! /bin/sh 

# Network.sh PROTO=static or dhcp IP=x.x.x.x NET=x.x.x.x GW=x.x.x.x DNS=x.x.x.x SAVE=0 or 1

PARM_01=${1}
PARM_02=${2}
PARM_03=${3}
PARM_04=${4}
PARM_05=${5}
PARM_06=${6}
PARM_07=${7}

NETWORK_CONF=Network.conf
DHCP_DIR=/var/run
RESOLV_FILE=/etc/config/resolv.conf

BOOTPROTO=0
IP=0
NET=0
GW=0
DNS=0
SAVE=0

function ParseArgs()
{
	if [ ! $PARM_07 == 0 ]; then 
		echo " Too many execced argumnet value "
	 	return 	
	fi	
	
	for NUM in $PARM_01 $PARM_02 $PARM_03 $PARM_04 $PARM_05 $PARM_06 
	do
		PARMNUM=$NUM
		if [ ! "$PARM_$NUM" == ${PARMNUM##IP=} ]; then 
			IP=${PARMNUM##IP=}
			echo "IP=$IP"
		fi
		
		if [ ! "$PARM_$NUM" == ${PARMNUM##NET=} ]; then
			NET=${PARMNUM##NET=}
			echo "NET=$NET"
		fi

		if [ ! "$PARM_$NUM" == ${PARMNUM##GW=} ]; then
			GW=${PARMNUM##GW=}
			echo "GW=$GW"
		fi

		if [ ! "$PARM_$NUM" == ${PARMNUM##PROTO=} ]; then
			BOOTPROTO=${PARMNUM##PROTO=}
			echo "PROTO=$BOOTPROTO"
		fi

		if [ ! "$PARM_$NUM" == ${PARMNUM##DNS=} ]; then
			DNS=${PARMNUM##DNS=}
			echo "DNS=$DNS"
		fi

		if [ ! "$PARM_$NUM" == ${PARMNUM##SAVE=} ]; then
			SAVE=${PARMNUM##SAVE=}
			echo "SAVE=$SAVE"
		fi
	done
}

function WriteNetInfo()
{
	if [ "$BOOTPROTO" == "dhcp" ];then 
		echo "BOOTPROTO=dhcp"  > /etc/$NETWORK_CONF
		echo "IPADDR=" >> /etc/$NETWORK_CONF
		echo "NETMASK=" >> /etc/$NETWORK_CONF
		echo "GWADDR=" >> /etc/$NETWORK_CONF
		echo "DNS=" >> /etc/$NETWORK_CONF
	elif [ "$BOOTPROTO" == "static" ];then 
		echo "BOOTPROTO=static" > /etc/$NETWORK_CONF
		echo "IPADDR=$IP" >> /etc/$NETWORK_CONF
		echo "NETMASK=$NET" >> /etc/$NETWORK_CONF
		if [ 0 == "$IS_ERROR" ]; then
			echo "GWADDR=$GW" >> /etc/$NETWORK_CONF
		else
			echo "GWADDR=0.0.0.0" >> /etc/$NETWORK_CONF
		fi
		echo "nameserver $DNS" > $RESOLV_FILE
		echo "DNS=$DNS" >> /etc/$NETWORK_CONF
	fi
	
	echo "NFSSVR=" >> /etc/$NETWORK_CONF
	echo "NFSDIR=" >> /etc/$NETWORK_CONF
}

function StopDhcp()
{
	if [ -f $DHCP_DIR/dhcpcd-eth0.pid ]; then
		cat $DHCP_DIR/dhcpcd-eth0.pid  | xargs kill -9 
		rm -f $DHCP_DIR/dhcpcd-eth0.*
	fi
}

function StartDhcp()
{
	StopDhcp

	echo "dhcpcd -Hd eth0"
	/bin/dhcpcd -k eth0 
	/bin/dhcpcd -Hd -L $DHCP_DIR eth0 & 
}

function StartStatic()
{	
	if [ "$IP" == 0 ]; then
		echo "No Ipaddress !!"
		return 0
	elif [ "$NET" == 0 ]; then
		echo "No Netmask !!"
		return 0 	
	elif [ "$GW" == 0 ]; then
		echo "No Gateway !!"
		return 0 
	fi
	
	StopDhcp

	/bin/ifconfig eth0 "$IP" netmask "$NET" up 
	/bin/route del default
	/bin/route add default gw "$GW" eth0
	IS_ERROR=$?
	echo "error = "$IS_ERROR
}

function CopyConfigFile()
{
	if [ "$SAVE" == 1 ]; then
		echo "result of conf. will be saved"
		yes | cp -adp /etc/$NETWORK_CONF /mnt/flash/Resource/$NETWORK_CONF
	fi
}

function Main()
{
	ParseArgs
	if [ "$BOOTPROTO" == "dhcp" ]; then 
		StartDhcp
	elif [ "$BOOTPROTO" == "static" ]; then 
		StartStatic
	fi

	if [ "$BOOTPROTO" == "0" ]; then 
		echo "No PROTO !!"
	        return 	
	fi
	
	WriteNetInfo
	CopyConfigFile
}

function PrintUsage()
{
	echo "Usage: `basename $0` PROTO=static or dhcp IP=x.x.x.x NET=x.x.x.x GW=x.x.x.x DNS=x.x.x.x"
}

if [ $# == 0 ]; then
	PrintUsage
	exit 0
fi

Main
/bin/ifconfig lo 127.0.0.1 netmask 255.0.0.0
