DEVICE=""
MPOINT=""
REPAIR_TYPE=""

function SetEnv()
{
	export LD_LIBRARY_PATH=/Lib
	export PATH=$PATH:/Bin
	HDD_INFO_FILE=/tmp/HddMountInfo.conf
}

function DoMount()
{
	/bin/nice -n 10 /bin/mount -t xfs $DEVICE $MPOINT
}

function DoRepair()
{
	xfs_repair $REPAIR_OPTION $DEVICE
}

function SendEvent()
{
	EVENT_ID=1045
	STATUS=$1
	DATA="$MPOINT,$STATUS"
	echo "/Bin/EventNotifier localhost $EVENT_ID $DATA"
	/Bin/EventNotifier localhost $EVENT_ID $DATA
	echo "$DATA" > HDD_INFO_FILE
}

function Main()
{
	TRY_TO_MOUNT=1
	SUCCESS_TO_MOUNT=2
	FAIL_TO_MOUNT=3 
	SUCCESS_TO_REPAIR=4
	SUCCESS_TO_MOUNT_AFTER_REPAIR=5
	FAIL_TO_MOUNT_AFTER_REPAIR=6
	FAIL_TO_REPAIR=7
	SendEvent $TRY_TO_MOUNT
	touch /tmp/mounting
	DoMount
	IS_MOUNT=`mount | grep "$DEVICE" | wc -l`
	if [ 0 == "$IS_MOUNT" ]; then
		echo "not mounted"
		SendEvent $FAIL_TO_MOUNT
# 		DoRepair
# 		IS_ERROR=$?
# 		echo "error = $IS_ERROR"
# 		if [ 0 == "$IS_ERROR" ]; then
# 			echo "Repair OK"
# 			SendEvent $SUCCESS_TO_REPAIR
# 			DoMount
# 			IS_MOUNT=`mount | grep "$DEVICE" | wc -l`
# 			if [ 0 == "$IS_MOUNT" ]; then
# 				echo "fail to mount after repair"
# 				SendEvent $FAIL_TO_MOUNT_AFTER_REPAIR
# 			else
# 				SendEvent $SUCCESS_TO_MOUNT_AFTER_REPAIR
# 			fi
# 		else
# 			echo "fail to repair"
# 			SendEvent $FAIL_TO_REPAIR
#		fi
	else
		SendEvent $SUCCESS_TO_MOUNT
	fi
	rm -f /tmp/mounting
}

DEVICE=$1
MPOINT=$2
REPAIR_OPTION=$3
SetEnv
Main
