#!/bin/sh

source /Bin/RedDb.sh

function SetDoFactoryResetEnv()
{
	CONF_PATH=/mnt/flash/Resource
	
	SetRedDbEnv
}

function ResetConf()
{
	rm -f $CONF_PATH/*.conf
}

function ResetDb()
{
	rm -f $RUN_DB_PATH/*.db
	rm -f $SHADOW_DB_PATH/$APP_DB
	rm -f $SHADOW_DB_PATH/$SCHEDULE_DATA
}

function ResetAll()
{
	ResetConf
	ResetDb
	sync;
	
	FLASH_ROOT=/mnt/flash
	APP_RAW_DEVICE=/dev/mtd0
	umount $FLASH_ROOT
	flash_eraseall $APP_RAW_DEVICE
}
