<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" encoding="UTF-8"/>
  <xsl:template match="/">
    <html>
      <body>
        <table border="1" style="background-color: White; width:99%;  border-width: 1px; border-style: inset;border-collapse: collapse;">

          <TR>
            <TD colspan="3" style="width:100%;">
              <B>System &amp; Application Info</B>
            </TD>
          </TR>


          <TR>
            <TD style="width:15%;">
              <B>ID</B>
            </TD>
            <TD style="width:35%;">
              <B>Name</B>
            </TD>
            <TD style="width:50%;">
              <B>Value</B>
            </TD>
          </TR>


          <xsl:for-each select="/diagnostics_data/system/system_item">
            <TR>
              <TD style="width:15%;">
                <xsl:value-of select="uid" />
              </TD>
              <TD style="width:35%;">
                <xsl:value-of select="name" />
              </TD>
              <TD style="width:50%;">
                <xsl:value-of select="value" />
              </TD>
            </TR>
          </xsl:for-each>


          <!--


          <TR>
            <TD colspan="3" style="width:100%;">
              <B>Ethernet Adapter Info</B>
            </TD>
          </TR>

          <TR>
            <TD style="width:15%;">
              <B>ID</B>
            </TD>
            <TD style="width:35%;">
              <B>Name</B>
            </TD>
            <TD style="width:50%;">
              <B>Value</B>
            </TD>
          </TR>
          <xsl:for-each select="/diagnostics_data/connection/network_status/bearers/bearer">
            <xsl:if test="@type='ENET'">
              <TR>
                <TD style="width:15%;">
                  ENET Item
                </TD>
                <TD style="width:35%;">
                  Signal Status
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="signal_status/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  ENET Item
                </TD>
                <TD style="width:35%;">
                  Signal Details
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="signal_status_details/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  ENET Item
                </TD>
                <TD style="width:35%;">
                  Connection Status
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="connection_status/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  ENET Item
                </TD>
                <TD style="width:35%;">
                  Connection Details
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="connection_status_details/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  ENET Item
                </TD>
                <TD style="width:35%;">
                  Adapter State
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_state/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  ENET Item
                </TD>
                <TD style="width:35%;">
                  Adapter Name
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/device_name/@value" />
                </TD>
              </TR>
            </xsl:if>
          </xsl:for-each>
          
          
          
          
          

          
           <TR>
                <TD colspan="3" style="width:100%;">
                  <B>WLAN Adapter Info</B>
                </TD>
           </TR>
    
            <TR>
              <TD style="width:15%;">
                <B>ID</B>
              </TD>
              <TD style="width:35%;">
                <B>Name</B>
              </TD>
              <TD style="width:50%;">
                <B>Value</B>
              </TD>
            </TR>
                <xsl:for-each select="/diagnostics_data/connection/network_status/bearers/bearer">
                 <xsl:if test="@type='WLAN'">
                    <TR>
                      <TD style="width:15%;">
                        WLAN Item
                      </TD>
                      <TD style="width:35%;">
                        Signal Status
                      </TD>
                      <TD style="width:50%;">
                        <xsl:value-of select="signal_status/@value" />
                      </TD>
                    </TR>
                   <TR>
                     <TD style="width:15%;">
                       WLAN Item
                     </TD>
                     <TD style="width:35%;">
                       Signal Details
                     </TD>
                     <TD style="width:50%;">
                       <xsl:value-of select="signal_status_details/@value" />
                     </TD>
                   </TR>
                   <TR>
                     <TD style="width:15%;">
                       WLAN Item
                     </TD>
                     <TD style="width:35%;">
                       Connection Status
                     </TD>
                     <TD style="width:50%;">
                       <xsl:value-of select="connection_status/@value" />
                     </TD>
                   </TR>
                   <TR>
                     <TD style="width:15%;">
                       WLAN Item
                     </TD>
                     <TD style="width:35%;">
                       Connection Details
                     </TD>
                     <TD style="width:50%;">
                       <xsl:value-of select="connection_status_details/@value" />
                     </TD>
                   </TR>
                   <TR>
                     <TD style="width:15%;">
                       WLAN Item
                     </TD>
                     <TD style="width:35%;">
                       Adapter State
                     </TD>
                     <TD style="width:50%;">
                       <xsl:value-of select="adapter_state/@value" />
                     </TD>
                   </TR>
                   <TR>
                     <TD style="width:15%;">
                       WLAN Item
                     </TD>
                     <TD style="width:35%;">
                       Adapter Name
                     </TD>
                     <TD style="width:50%;">
                       <xsl:value-of select="adapter_props/device_name/@value" />
                     </TD>
                   </TR>
                   <TR>
                     <TD style="width:15%;">
                       WLAN Item
                     </TD>
                     <TD style="width:35%;">
                       Mac Address
                     </TD>
                     <TD style="width:50%;">
                       <xsl:value-of select="adapter_props/mac_address/@value" />
                     </TD>
                   </TR>
              </xsl:if>
            </xsl:for-each>
          
          -->

          <TR>
            <TD colspan="3" style="width:100%;">
              <B>WWAN Adapter Info</B>
            </TD>
          </TR>


          <TR>
            <TD style="width:15%;">
              <B>ID</B>
            </TD>
            <TD style="width:35%;">
              <B>Name</B>
            </TD>
            <TD style="width:50%;">
              <B>Value</B>
            </TD>
          </TR>

          <xsl:for-each select="/diagnostics_data/connection/network_status/bearers/bearer">
            <xsl:if test="@type='WWAN'">
              <TR>
                <TD style="width:15%;">
                  WW-1000
                </TD>
                <TD style="width:35%;">
                  Signal Status
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="signal_status/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1001
                </TD>
                <TD style="width:35%;">
                  Signal Details
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="signal_status_details/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1002
                </TD>
                <TD style="width:35%;">
                  Connection Status
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="connection_status/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1003
                </TD>
                <TD style="width:35%;">
                  Connection Details
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="connection_status_details/@value" />
                </TD>
              </TR>
							<TR>
								<TD style="width:15%;">
									WW-1004
								</TD>
								<TD style="width:35%;">
									APN Profile Type
								</TD>
								<TD style="width:50%;">
									<xsl:value-of select="wwan_profiletype/@value" />
								</TD>
							</TR>
							<TR>
								<TD style="width:15%;">
									WW-1005
								</TD>
								<TD style="width:35%;">
									APN Profile Name
								</TD>
								<TD style="width:50%;">
									<xsl:value-of select="wwan_profilename/@value" />
								</TD>
							</TR>
              
              <TR>
                <TD style="width:15%;">
                  WW-1006
                </TD>
                <TD style="width:35%;">
                  APN
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="wwan_apn/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1007
                </TD>
                <TD style="width:35%;">
                  Username
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="wwan_username/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1008
                </TD>
                <TD style="width:35%;">
                  Adapter State
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_state/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1009
                </TD>
                <TD style="width:35%;">
                  Adapter Name
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/device_name/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1010
                </TD>
                <TD style="width:35%;">
                  Adapter Type
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_type/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1011
                </TD>
                <TD style="width:35%;">
                  Adapter Manufacturer
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_manufacturer/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1012
                </TD>
                <TD style="width:35%;">
                  Adapter Model
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_model/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1013
                </TD>
                <TD style="width:35%;">
                  Adapter Revision
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_revision/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1014
                </TD>
                <TD style="width:35%;">
                  Adapter IMEI
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_imei/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1015
                </TD>
                <TD style="width:35%;">
                  Adapter IMSI
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_imsi/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1016
                </TD>
                <TD style="width:35%;">
                  Adapter ICCID
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_iccid/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1017
                </TD>
                <TD style="width:35%;">
                  Adapter MDN
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_mdn/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1018
                </TD>
                <TD style="width:35%;">
                  Adapter MEID
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_meid/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1019
                </TD>
                <TD style="width:35%;">
                  Adapter ESN
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_esn/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1020
                </TD>
                <TD style="width:35%;">
                  Firmware Revision
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_firmware_revision/@value" />
                </TD>
              </TR>

              <TR>
                <TD style="width:15%;">
                  WW-1021
                </TD>
                <TD style="width:35%;">
                  IP Address
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_ip/@value" />
                </TD>
              </TR>

              <TR>
                <TD style="width:15%;">
                  WW-1022
                </TD>
                <TD style="width:35%;">
                  Signal Strength
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_signal_strength/@value" />
                </TD>
              </TR>
            
              <TR>
                <TD style="width:15%;">
                  WW-1023
                </TD>
                <TD style="width:35%;">
                  PRL Version
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_prl/@value" />
                </TD>
              </TR>
               <TR>
                <TD style="width:15%;">
                  WW-1024
                </TD>
                <TD style="width:35%;">
                  ERI Version
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_eri/@value" />
                </TD>
              </TR>
                <TR>
                <TD style="width:15%;">
                  WW-1025
                </TD>
                <TD style="width:35%;">
                  MIN
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_min/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1026
                </TD>
                <TD style="width:35%;">
                  SID
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_sid/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1027
                </TD>
                <TD style="width:35%;">
                  RSSI (1xRTT)
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_rssirtt/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1028
                </TD>
                <TD style="width:35%;">
                  RSSI (1xEVDO)
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_rssievdo/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  WW-1029
                </TD>
                <TD style="width:35%;">
                  Capabilities
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/wwan_bearers/@value" />
                </TD>
              </TR>
            </xsl:if>
          </xsl:for-each>

          <xsl:for-each select="/diagnostics_data/connection/network_status/connection_stats">
            <TR>
              <TD style="width:15%;">
                WW-1030
              </TD>
              <TD style="width:35%;">
                Data Received
              </TD>
              <TD style="width:50%;">
                <xsl:value-of select="bytes_in/@value" />
              </TD>
            </TR>
            <TR>
              <TD style="width:15%;">
                WW-1031
              </TD>
              <TD style="width:35%;">
                Data Transferred
              </TD>
              <TD style="width:50%;">
                <xsl:value-of select="bytes_out/@value" />
              </TD>
            </TR>
          </xsl:for-each>


          <!--

          <TR>
            <TD colspan="3" style="width:100%;">
              <B>Dialup Adapter Info</B>
            </TD>
          </TR>

          <TR>
            <TD style="width:15%;">
              <B>ID</B>
            </TD>
            <TD style="width:35%;">
              <B>Name</B>
            </TD>
            <TD style="width:50%;">
              <B>Value</B>
            </TD>
          </TR>
          <xsl:for-each select="/diagnostics_data/connection/network_status/bearers/bearer">
            <xsl:if test="@type='PSTN'">
              <TR>
                <TD style="width:15%;">
                  Dial Item
                </TD>
                <TD style="width:35%;">
                  Signal Status
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="signal_status/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  Dial Item
                </TD>
                <TD style="width:35%;">
                  Signal Details
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="signal_status_details/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  Dial Item
                </TD>
                <TD style="width:35%;">
                  Connection Status
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="connection_status/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  Dial Item
                </TD>
                <TD style="width:35%;">
                  Connection Details
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="connection_status_details/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  Dial Item
                </TD>
                <TD style="width:35%;">
                  Adapter State
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_state/@value" />
                </TD>
              </TR>
              <TR>
                <TD style="width:15%;">
                  Dial Item
                </TD>
                <TD style="width:35%;">
                  Adapter Name
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="adapter_props/device_name/@value" />
                </TD>
              </TR>
            </xsl:if>
          </xsl:for-each>
       -->

          <!--
            <xsl:for-each select="/diagnostics_data/wwan/wwan_item">
              <TR>
                <TD style="width:15%;">
                  <xsl:value-of select="uid" />
                </TD>
                <TD style="width:35%;">
                  <xsl:value-of select="name" />
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="value" />
                </TD>
              </TR>
            </xsl:for-each>
        

          
            <TR>
              <TD colspan="3"  style="width:100%;">
                <B>Modem Info</B>
              </TD>
            </TR>
          
          
            <TR>
              <TD style="width:15%;">
                <B>ID</B>
              </TD>
              <TD style="width:35%;">
                <B>Name</B>
              </TD>
              <TD style="width:50%;">
                <B>Value</B>
              </TD>
            </TR>
          
          
            <xsl:for-each select="/diagnostics_data/modem/modem_item">
              <TR>
                <TD style="width:15%;">
                  <xsl:value-of select="uid" />
                </TD>
                <TD style="width:35%;">
                  <xsl:value-of select="name" />
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="value" />
                </TD>
              </TR>
            </xsl:for-each>
          

          
            <TR>
              <TD colspan="3" style="width:100%;">
                <B>Network Adapters</B>
              </TD>
            </TR>
          
          
            <TR>
              <TD style="width:15%;">
                <B>ID</B>
              </TD>
              <TD style="width:35%;">
                <B>Name</B>
              </TD>
              <TD style="width:50%;">
                <B>Value</B>
              </TD>
            </TR>
          
          
            <xsl:for-each select="/diagnostics_data/network/network_item">
              <TR>
                <TD style="width:15%;">
                  <xsl:value-of select="uid" />
                </TD>
                <TD style="width:35%;">
                  <xsl:value-of select="name" />
                </TD>
                <TD style="width:50%;">
                  <xsl:value-of select="value" />
                </TD>
              </TR>
            </xsl:for-each>
            -->

        </table>
      </body>
    </html>
  </xsl:template>

</xsl:stylesheet>