

(function($) {
	$.fn.validationEngineLanguage = function() {};
	$.validationEngineLanguage = {
		newLang: function() {
			$.validationEngineLanguage.allRules = 	{"required":{    			// Add your regex rules here, you can take telephone as an example
						"regex":"none",
						"alertText":"* Preden kliknete Pošlji, izpolnite vse zahtevane informacije.",
						"alertTextCheckboxMultiple":"* Prosim, preverite škatlo",
						"alertTextCheckboxe":"* Prosim, preverite škatlo"},
					"length":{
						"regex":"none",
						"alertText":"* Vrednost mora biti med ",
						"alertText2":" in ",
						"alertText3": "."},
					"maxCheckbox":{
						"regex":"none",
						"alertText":"* Checks allowed Exceeded"},	
					"minCheckbox":{
						"regex":"none",
						"alertText":"* Please select ",
						"alertText2":" options"},	
					"confirm":{
						"regex":"none",
						"alertText":"* Your field is not matching"},		
					"telephone":{
						"regex":"/^[0-9\-\(\)\ ]+$/",
						"alertText":"* Ta telefonska številka ni vredna: <br/><span>E.g. 00441234567890</span>"},	
					"email":{
						"regex":"/^[a-zA-Z0-9_\.\-]+\@([a-zA-Z0-9\-]+\.)+[a-zA-Z0-9]{2,4}$/",
						"alertText":"* Ta e-mail naslov ni vreden: <br /><span>E.g. yourname@domain.com</span>"},	
					"date":{
                         "regex":"/^[0-9]{4}\-\[0-9]{1,2}\-\[0-9]{1,2}$/",
                         "alertText":"* Invalid date, must be in YYYY-MM-DD format"},
					"onlyNumber":{
						"regex":"/^[0-9\ ]+$/",
						"alertText":"* Vneseno število ni veljavno."},	
					"noSpecialCaracters":{
						"regex":"/^[0-9a-zA-Z]+$/",
						"alertText":"* V to okno lahko vnesete samo besedilo in številke."},	
					"ajaxUser":{
						"file":"validateUser.php",
						"extraData":"name=eric",
						"alertTextOk":"* This user is available",	
						"alertTextLoad":"* Loading, please wait",
						"alertText":"* This user is already taken"},	
					"ajaxName":{
						"file":"validateUser.php",
						"alertText":"* This name is already taken",
						"alertTextOk":"* This name is available",	
						"alertTextLoad":"* Loading, please wait"},		
					"onlyLetter":{
						"regex":"/^[a-zA-Z\ \']+$/",
						"alertText":"* V to okno lahko vnesete samo besedilo."},
					"validate2fields":{
    					"nname":"validate2fields",
    					"alertText":"* You must have a firstname and a lastname"},
						
						// --- CUSTOM RULES -- Those are specific to the support website
							"pc":{
    				"regex":"/^[0-9]{7,8}$/", 
    				"alertText":"* Serijska številka (A) neveljavna"},
					"sn":{
    				"regex":"/^[0-9]{7}$/",
    				"alertText":"* Serijska številka (B) neveljavna"},
					
					"validpc": {
						"regex": "/^[^0][0-9]+$/",
						"alertText":"* Koda izdelka ni pravilna"},
					"validateWarr": {
						"nname":"validateWarr",
						"alertText":"* The format is incorrect"}	
			}
		}
	}
})(jQuery);

$(document).ready(function() {	
	$.validationEngineLanguage.newLang()
});﻿