

(function($) {
	$.fn.validationEngineLanguage = function() {};
	$.validationEngineLanguage = {
		newLang: function() {
			$.validationEngineLanguage.allRules = 	{"required":{    			// Add your regex rules here, you can take telephone as an example
						"regex":"none",
						"alertText":"* &#1042;&#1077; &#1084;&#1086;&#1083;&#1080;&#1084;&#1077; &#1074;&#1085;&#1077;&#1089;&#1077;&#1090;&#1077; &#1075;&#1080; &#1089;&#1080;&#1090;&#1077; &#1087;&#1086;&#1090;&#1088;&#1077;&#1073;&#1085; &#1080;&#1085;&#1092;&#1086;&#1088;&#1084;&#1072;&#1095;&#1080;&#1080; &#1087;&#1088;&#1077;&#1076; &#1076;&#1072; &#1082;&#1083;&#1080;&#1082;&#1085;&#1077;&#1090;&#1077; Send &#40;&#1048;&#1089;&#1087;&#1088;&#1072;&#1090;&#1080;&#41;",
						"alertTextCheckboxMultiple":"* &#1042;&#1077; &#1084;&#1086;&#1083;&#1080;&#1084;&#1077; &#1087;&#1088;&#1086;&#1074;&#1077;&#1088;&#1077;&#1090;&#1077; &#1075;&#1086; &#1082;&#1074;&#1072;&#1076;&#1088;&#1072;&#1090;&#1095;&#1077;&#1090;&#1086;",
						"alertTextCheckboxe":"* &#1042;&#1077; &#1084;&#1086;&#1083;&#1080;&#1084;&#1077; &#1087;&#1088;&#1086;&#1074;&#1077;&#1088;&#1077;&#1090;&#1077; &#1075;&#1086; &#1082;&#1074;&#1072;&#1076;&#1088;&#1072;&#1090;&#1095;&#1077;&#1090;&#1086;"},
					"length":{
						"regex":"none",
						"alertText":"* &#1042;&#1056;&#1077;&#1076;&#1085;&#1086;&#1089;&#1090;&#1072; &#1084;&#1086;&#1088;&#1072; &#1076;&#1072; &#1073;&#1080;&#1076;&#1077; &#1087;&#1086;&#1084;&#1077;&#1075;&#1091; ",
						"alertText2":" &#1080; ",
						"alertText3": "."},
					"maxCheckbox":{
						"regex":"none",
						"alertText":"* Checks allowed Exceeded"},	
					"minCheckbox":{
						"regex":"none",
						"alertText":"* Please select ",
						"alertText2":" options"},	
					"confirm":{
						"regex":"none",
						"alertText":"* Your field is not matching"},		
					"telephone":{
						"regex":"/^[0-9\-\(\)\ ]+$/",
						"alertText":"* &#1058;&#1077;&#1083;&#1077;&#1092;&#1086;&#1085;&#1089;&#1082;&#1080;&#1086;&#1090; &#1073;&#1088;&#1086;&#1112; &#1096;&#1090;&#1086; &#1075;&#1086; &#1074;&#1086;&#1074;&#1077;&#1076;&#1086;&#1074;&#1090;&#1077; &#1077; &#1085;&#1077;&#1074;&#1072;&#1083;&#1080;&#1076;&#1077;&#1085; <br/><span>E.g. 00441234567890</span>"},	
					"email":{
						"regex":"/^[a-zA-Z0-9_\.\-]+\@([a-zA-Z0-9\-]+\.)+[a-zA-Z0-9]{2,4}$/",
						"alertText":"* &#1045;&#1084;&#1072;&#1080;&#1083; &#1072;&#1076;&#1088;&#1077;&#1089;&#1072;&#1090;&#1072; &#1096;&#1090;&#1086; &#1112;&#1072; &#1074;&#1086;&#1074;&#1077;&#1076;&#1086;&#1074;&#1090;&#1077; &#1077; &#1085;&#1077;&#1074;&#1072;&#1083;&#1080;&#1076;&#1085;&#1072 <br /><span>E.g. yourname@domain.com</span>"},	
					"date":{
                         "regex":"/^[0-9]{4}\-\[0-9]{1,2}\-\[0-9]{1,2}$/",
                         "alertText":"* Invalid date, must be in YYYY-MM-DD format"},
					"onlyNumber":{
						"regex":"/^[0-9\ ]+$/",
						"alertText":"* &#1042;&#1085;&#1077;&#1089;&#1077;&#1085;&#1080;&#1086;&#1090; &#1073;&#1088;&#1086;j &#1077; &#1087;&#1086;&#1075;&#1088;&#1077;&#1096;&#1077;&#1085;."},	
					"noSpecialCaracters":{
						"regex":"/^[0-9a-zA-Z]+$/",
						"alertText":"* &#1042;&#1086; &#1086;&#1074;&#1072; &#1087;&#1086;&#1083;&#1077; &#1084;&#1086;&#1078;&#1077; &#1076;&#1072; &#1089;&#1077; &#1074;&#1085;&#1077;&#1089;&#1072;&#1090; &#1089;&#1072;&#1084;&#1086; &#1090;&#1077;&#1082;&#1089;&#1090; &#1080; &#1073;&#1056;&#1086;&#1077;&#1074;&#1080;"},	
					"ajaxUser":{
						"file":"validateUser.php",
						"extraData":"name=eric",
						"alertTextOk":"* This user is available",	
						"alertTextLoad":"* Loading, please wait",
						"alertText":"* This user is already taken"},	
					"ajaxName":{
						"file":"validateUser.php",
						"alertText":"* This name is already taken",
						"alertTextOk":"* This name is available",	
						"alertTextLoad":"* Loading, please wait"},		
					"onlyLetter":{
						"regex":"/^[a-zA-Z\ \']+$/",
						"alertText":"* &#1042;&#1086; &#1086;&#1074;&#1072; &#1087;&#1086;&#1076;&#1077; &#1084;&#1086;&#1078;&#1077; &#1076;&#1072; &#1089;&#1077; &#1074;&#1085;&#1077;&#1089;&#1077; &#1089;&#1072;&#1084;&#1086; &#1090;&#1077;&#1082;&#1089;&#1090;"},
					"validate2fields":{
    					"nname":"validate2fields",
    					"alertText":"* You must have a firstname and a lastname"},
						
						// --- CUSTOM RULES -- Those are specific to the support website
						"pc":{
    				"regex":"/^[0-9]{7,8}$/", 
    				"alertText":"* ??????? ???? (A) ???????"},
					"sn":{
    				"regex":"/^[0-9]{7}$/",
    				"alertText":"*  ??????? ???? (B) ???????"},
					
					"validpc": {
						"regex": "/^[^0][0-9]+$/",
						"alertText":"* &#1050;&#1086;&#1076;&#1086;&#1090; &#1079;&#1072; &#1087;&#1088;&#1086;&#1080;&#1079;&#1074;&#1086;&#1076;&#1086;&#1090; &#1077; &#1085;&#1077;&#1087;&#1088;&#1072;&#1074;&#1080;&#1083;&#1077;&#1085;"},
					"validateWarr": {
						"nname":"validateWarr",
						"alertText":"* The format is incorrect"}	
			}
		}
	}
})(jQuery);

$(document).ready(function() {	
	$.validationEngineLanguage.newLang()
});