

(function($) {
	$.fn.validationEngineLanguage = function() {};
	$.validationEngineLanguage = {
		newLang: function() {
			$.validationEngineLanguage.allRules = 	{"required":{    			// Add your regex rules here, you can take telephone as an example
						"regex":"none",
						"alertText":"* Geben Sie alle erforderlichen Informationen ein, bevor Sie auf Senden klicken.",
						"alertTextCheckboxMultiple":"* Bitte aktivieren Sie das K&#228;stchen",
						"alertTextCheckboxe":"* Bitte aktivieren Sie das K&#228;stchen"},
					"length":{
						"regex":"none",
						"alertText":"*Der Wert muss liegen zwischen ",
						"alertText2":" und ",
						"alertText3": "."},
					"maxCheckbox":{
						"regex":"none",
						"alertText":"* Checks allowed Exceeded"},	
					"minCheckbox":{
						"regex":"none",
						"alertText":"* Please select ",
						"alertText2":" options"},	
					"confirm":{
						"regex":"none",
						"alertText":"* Das Feld ist verschieden von"},		
					"telephone":{
						"regex":"/^[0-9\-\(\)\ ]+$/",
						"alertText":"* Die eingegebene Telefonnummer ist ungltig."},	
					"email":{
						"regex":"/^[a-zA-Z0-9_\.\-]+\@([a-zA-Z0-9\-]+\.)+[a-zA-Z0-9]{2,4}$/",
						"alertText":"* Die eingegebene E-Mail-Adresse ist ung&uuml;ltig."},	
					"date":{
                         "regex":"/^[0-9]{4}\-\[0-9]{1,2}\-\[0-9]{1,2}$/",
                         "alertText":"* Invalid date, must be in YYYY-MM-DD format"},
					"onlyNumber":{
						"regex":"/^[0-9\ ]+$/",
						"alertText":"* Die eingegebene Zahl ist ung&#252;ltig."},	
					"noSpecialCaracters":{
						"regex":"/^[0-9a-zA-Z]+$/",
						"alertText":"* Dieses Feld akzeptiert nur Text und Zahlen."},	
					"ajaxUser":{
						"file":"validateUser.php",
						"extraData":"name=eric",
						"alertTextOk":"* This user is available",	
						"alertTextLoad":"* Loading, please wait",
						"alertText":"* This user is already taken"},	
					"ajaxName":{
						"file":"validateUser.php",
						"alertText":"* This name is already taken",
						"alertTextOk":"* This name is available",	
						"alertTextLoad":"* Loading, please wait"},		
					"onlyLetter":{
						"regex":"/^[a-zA-Z\ \']+$/",
						"alertText":"* Dieses Feld akzeptiert nur Text"},
					"validate2fields":{
    					"nname":"validate2fields",
    					"alertText":"* You must have a firstname and a lastname"},
						
						// --- CUSTOM RULES -- Those are specific to the support website
					"pc":{
    				"regex":"/^[0-9]{7,8}$/", 
    				"alertText":"* Seriennummer (A) ist ungltig"},
					"sn":{
    				"regex":"/^[0-9]{7}$/",
    				"alertText":"* Seriennummer (B) ist ungltig"},
					
					"validpc": {
						"regex": "/^[^0][0-9]+$/",
						"alertText":"* Der Produktcode ist falsch"},
					"validateWarr": {
						"nname":"validateWarr",
						"alertText":"* The format is incorrect"}	
					}	
					
		}
	}
})(jQuery);

$(document).ready(function() {	
	$.validationEngineLanguage.newLang()
});