function fncSearchKeyDown(nKeyCode, strValue, obj) {
	try{

		// NOTE: IEでは、buttonのtypeがsubmitにより、下記がなくても[Enter]で検索可能
//		if (!document.all) {
			if (nKeyCode == 13) {
				if(obj != undefined){
					document.getElementById("id_search_button_sub").click();
				}else{
					document.getElementById("id_search_button").click();
				}
			}
//		}
		if (strValue == fncGetResourceByResourceId("enter_search_keyword")) {
			if (document.getElementById("id_search")) {
				document.getElementById("id_search").value = "";
				document.getElementById("id_search").style.color = "#000000";
			} else if (document.getElementById("id_search_texts")) {
				document.getElementById("id_search_texts").value = "";
				document.getElementById("id_search_texts").style.color = "#000000";
			}
		}
	} catch (e) {
	}
}

// ------------------------------------------------------------------------------------------------
// GetResourceByResourceId
// ------------------------------------------------------------------------------------------------
function fncGetResourceByResourceId(resource_id) {
	try {
		var r = eval(resource);
		var nRLength = r.length;
		for (var i = 0; i < nRLength; i++) {
			if (r[i].id == resource_id) {
				return r[i].value;
			}
		}
		return "";
	} catch (e) {
	}
}

// ------------------------------------------------------------------------------------------------
// display values from resouce
// ------------------------------------------------------------------------------------------------
function fncLoadResource() {
	try {

		var r = eval(resource);
		var nRLength = r.length;
		for (var i = 0; i < nRLength; i++) {

			if (document.getElementById("id_res_" + r[i].id)) {
				document.getElementById("id_res_" + r[i].id).innerHTML = r[i].value;
			}

			// <title>
			if (document.title == "") {
				if (r[i].id == "title") {
					document.title = r[i].value;
				}
			}
		}
	} catch (e) {
	}
}

// ------------------------------------------------------------------------------------------------
// SearchBox
// ------------------------------------------------------------------------------------------------
function fncSearchBox() {
	try {
		if (document.getElementById("id_search")) {
			if (document.getElementById("id_search").value == "") {
				document.getElementById("id_search").value = fncGetResourceByResourceId("enter_search_keyword");
			}

			if (document.getElementById("id_search").value == fncGetResourceByResourceId("enter_search_keyword")) {
				document.getElementById("id_search").style.color = "#808080";
			}

			// onclick
			document.getElementById("id_search").onclick = function() {
				if (this.value == fncGetResourceByResourceId("enter_search_keyword")) {
					this.value = "";
					document.getElementById("id_search").style.color = "#000000";
				}
			}

			// onblur
			document.getElementById("id_search").onblur = function() {
				if (this.value == "") {
					this.value = fncGetResourceByResourceId("enter_search_keyword");
					document.getElementById("id_search").style.color = "#808080";
				}
			}
		}
	} catch (e) {
	}

	try {
		if (document.getElementById("id_search_sub")) {
			if (document.getElementById("id_search_sub").value == "") {
				document.getElementById("id_search_sub").value = fncGetResourceByResourceId("enter_search_keyword");
			}

			if (document.getElementById("id_search_sub").value == fncGetResourceByResourceId("enter_search_keyword")) {
				document.getElementById("id_search_sub").style.color = "#808080";
			}

			// onclick
			document.getElementById("id_search_sub").onclick = function() {
				if (this.value == fncGetResourceByResourceId("enter_search_keyword")) {
					this.value = "";
					document.getElementById("id_search_sub").style.color = "#000000";
				}
			}

			// onblur
			document.getElementById("id_search_sub").onblur = function() {
				if (this.value == "") {
					this.value = fncGetResourceByResourceId("enter_search_keyword");
					document.getElementById("id_search_sub").style.color = "#808080";
				}
			}
		}
	} catch (e) {
	}
}

// ------------------------------------------------------------------------------------------------
// search engine
// ------------------------------------------------------------------------------------------------
var search;
function fncDoSearch(nPage) {
	try {

		// 入力された検索条件を取得
		var strSearchTexts = document.getElementById("id_search").value;

		// 前後のスペースを除去しておく
		// NOTE: IEとそれ以外のブラウザーで、前後にスペースがあるかどうかでsplitの結果が変わる（IEの場合、空の要素は省かれる）
		strSearchTexts = strSearchTexts.trim();

		// 検索条件表示用にJSONエスケープしない状態も残しておく（HTMLエスケープは必要）
		var strSearchTextsOriginal = strSearchTexts;

		// 検索条件が指定されていない場合は結果0件と見なす
		if (	(strSearchTexts == "")
			||	(strSearchTexts == fncGetResourceByResourceId("enter_search_keyword"))
		) {
			document.getElementById("id_search_results").innerHTML = fncGetNoneFoundMessage("");
			return;
		}

		// 検索条件をエスケープ
		var regexpEscapeJson = /([$()\-^\\\|\[\]{},:+*.?])/g;
		if (regexpEscapeJson.exec(strSearchTexts) != null) {
			strSearchTexts = strSearchTexts.replace(regexpEscapeJson, "\\$1");
		}
		var regexpEscapeHtmlAmp = /(&)/g;
		if (regexpEscapeHtmlAmp.exec(strSearchTexts) != null) {
			strSearchTexts = strSearchTexts.replace(regexpEscapeHtmlAmp, "&amp;");
			strSearchTextsOriginal = strSearchTextsOriginal.replace(regexpEscapeHtmlAmp, "&amp;");
		}
		var regexpEscapeHtmlLt = /(<)/g;
		if (regexpEscapeHtmlLt.exec(strSearchTexts) != null) {
			strSearchTexts = strSearchTexts.replace(regexpEscapeHtmlLt, "&lt;");
			strSearchTextsOriginal = strSearchTextsOriginal.replace(regexpEscapeHtmlLt, "&lt;");
		}
		var regexpEscapeHtmlGt = /(>)/g;
		if (regexpEscapeHtmlGt.exec(strSearchTexts) != null) {
			strSearchTexts = strSearchTexts.replace(regexpEscapeHtmlGt, "&gt;");
			strSearchTextsOriginal = strSearchTextsOriginal.replace(regexpEscapeHtmlGt, "&gt;");
		}

		// NOTE: ダブルクォーテーション自体は検索できない（完全一致検索のための囲み文字）

		// ----------------------------------------------------------------------------------------
		// 完全一致検索キーワードの切り分け
		// ----------------------------------------------------------------------------------------

		// 検索キーワード
		var bInQuot = false;
		var convert = new Array();
		var iLoopLength = strSearchTexts.length;

		// キーワード文字列を1文字ずつ走査
		for (var i = 0; i < iLoopLength; i++) {

			// 1文字取り出し
			var character = strSearchTexts.substring(i, i + 1);

			// ダブルクォーテーション開始・終了
			if (	(character == "\"")
				||	(character == "”")
				||	(character == "“")
			) {
				character = "";
				bInQuot = !bInQuot;

			// 囲み内にあるスペースはキーワード区切り文字としてみなさないようにするために退避
			} else if (bInQuot && ((character == " ") || (character == "　") || (character == "	"))) {
				character = "___SPACE___";
			}
			convert.push(character);
		}
		strSearchTexts = convert.join("");

		// 検索条件表示用キーワード
		var bInQuot = false;
		var convert = new Array();
		var iLoopLength = strSearchTextsOriginal.length;
		for (var i = 0; i < iLoopLength; i++) {
			var character = strSearchTextsOriginal.substring(i, i + 1);
			if (	(character == "\"")
				||	(character == "”")
				||	(character == "“")
			) {
				character = "";
				bInQuot = !bInQuot;
			} else if (bInQuot && ((character == " ") || (character == "　") || (character == "	"))) {
				character = "___SPACE___";
			}
			convert.push(character);
		}
		strSearchTextsOriginal = convert.join("");

		// ----------------------------------------------------------------------------------------
		// 複数指定された検索条件をスペースで区切る(全角スペースも許容)
		// ----------------------------------------------------------------------------------------
		//var res = / |　/;
		var res = /[\s　]+/;
		var arrSearchText = strSearchTexts.split(res);
		var arrSearchTextOriginal = strSearchTextsOriginal.split(res);

		// スペースしか入力されていない場合は検索処理をキャンセル
		if (arrSearchText.join("") == "") {
			document.getElementById("id_search").value = fncGetResourceByResourceId("enter_search_keyword");
			document.getElementById("id_search").style.color = "#808080";
			document.getElementById("id_search_results").innerHTML = fncGetNoneFoundMessage("");
			return false;
		}

		// 退避したダブルクォーテーション囲み内スペースを復元
		var iLoopLength = arrSearchText.length;
		for (var i = 0; i < iLoopLength; i++) {
			arrSearchText[i] = arrSearchText[i].replace(/___SPACE___/g, " ");
		}
		var iLoopLength = arrSearchTextOriginal.length;
		for (var i = 0; i < iLoopLength; i++) {
			arrSearchTextOriginal[i] = arrSearchTextOriginal[i].replace(/___SPACE___/g, " ");
		}

		// ----------------------------------------------------------------------------------------
		// 検索対象の絞込み
		// ----------------------------------------------------------------------------------------

		// カテゴリー絞込み状況を確認（トップページ・用語集での検索では絞込みしない）
		var strSelectedChaptersCount = "";

		// ----------------------------------------------------------------------------------------
		// 検索結果表示方法の定義
		// ----------------------------------------------------------------------------------------
		var iShowAround = fncGetConstantByName("search_show_around");
		if (!iShowAround) {
			iShowAround = 50;
		}
		var iShowAroundBefore = iShowAround;
		var iShowAroundAfter = iShowAround;
		var iShowResultCount = fncGetConstantByName("search_show_result_count");
		if (!iShowResultCount) {
			iShowResultCount = 10;
		}
		var iPageMaxRange = fncGetConstantByName("search_page_max_range"); // [2][3][4][5][6]
		if (!iPageMaxRange) {
			iPageMaxRange = 5;
		}
		var iPageRangeLeft = parseInt(iPageMaxRange / 2);
		var iPageRangeRight = parseInt(iPageMaxRange / 2);

		// 変数の初期化
		var strResultAll = "";
		var iFound = 0;
		var strPrevChapterId = "";
		var arrResults = new Array();
		var arrResultTopics = new Array();

		if (strWindowType != "GLOSSARY") {

			// 検索条件の表示
			arrResults.push(strSelectedChaptersCount);

			// 検索結果の表示する箇所を追加
			arrResults.push("<div class=\"search_result_conditions\" id=\"id_search_result_item\"></div>");
		}

		// ----------------------------------------------------------------------------------------
		// 検索条件による絞込み
		// ----------------------------------------------------------------------------------------
		var nSearchTextLength = arrSearchText.length;
		for (var j = 0; j < nSearchTextLength; j++) {

			var strSearchText = arrSearchText[j];

			// マルチバイトの区別
			if (document.getElementById("id_search_options_multibyte")) {
				if (document.getElementById("id_search_options_multibyte").checked) {
					strSearchText = fncConvertSearchText(strSearchText, true);
					arrSearchText[j] = strSearchText;
				}
			}

			// 大文字小文字の区別
			var strSearchOptionCaseSensitive = "i"; // 正規表現のフラグ「i」→区別あり
			if (document.getElementById("id_search_options_case")) {
				if (document.getElementById("id_search_options_case").checked) {
					strSearchOptionCaseSensitive = "";
				}

			// トップページ・用語集ではクッキーから設定内容を取得
			} else {
				if (fncGetCookie("SEARCH-OPTIONS-CASE") == "TRUE") {
					strSearchOptionCaseSensitive = "";
				}
			}
		}

		var iLoopLength = search.length;
		for (var i = 0; i < iLoopLength; i++) {

			// 検索先情報の取得
			var body = search[i].body;			// 本文
			var toc_id = search[i].toc_id;		// ID
			var title = fncGetEncodeText(search[i].title);			// タイトル

			// 本文が空ならスキップ
			if (!body) {
				continue;
			}

			// AND検索処理：指定検索条件分ループ
			var strResultTopic = "";
			var nSearchTextLength = arrSearchText.length;
			var arrSummaryText = new Array();
			for (var j = 0; j < nSearchTextLength; j++) {

				var strSearchText = arrSearchText[j];

				// --------------------------------------------------------------------------------
				// 検索実行
				// --------------------------------------------------------------------------------
				var strSearchTextParam = "(" + strSearchText + ")";
				var re = new RegExp(strSearchTextParam, strSearchOptionCaseSensitive);

				if (re.exec(body) == null) {

					// ヒット無し
					break;

				} else {

					// はじめに見つかった位置を調べる
					var iFoundPosition = body.search(re);
					if (iFoundPosition != -1) {

						// ------------------------------------------------------------------------
						// 実体参照文字列を除外する
						// ------------------------------------------------------------------------

						// ヒット位置から前方のテキストの末尾の「&」を探す
						var strAmpAfter = "";
						var strBeforeFound = body.substring(0, iFoundPosition);
						var nAmpAfter = strBeforeFound.lastIndexOf("&");
						if (strSearchText != "&") {
							if (nAmpAfter != -1) {
								strAmpAfter = strBeforeFound.substring(nAmpAfter);
							}
						}

						// ヒット位置から後方のテキストの最初の「;」を探す
						var strSemicolonBefore = "";
						var strAfterFound = body.substring(iFoundPosition + arrSearchTextOriginal[j].length);
						var nSemicolonBefore = strAfterFound.indexOf(";");
						if (arrSearchTextOriginal[j] != ";") {
							if (nSemicolonBefore != -1) {
								strSemicolonBefore = strAfterFound.substring(0, nSemicolonBefore + 1);
							}
						}

						// 文字列を結合してみる（小文字に揃えて評価）
						var strIsEntity = strAmpAfter + arrSearchTextOriginal[j].toLowerCase() + strSemicolonBefore;

						// 実体参照として成立した場合は、ヒット取消
						if (	(strIsEntity == "&amp;")
							||	(strIsEntity == "&lt;")
							||	(strIsEntity == "&gt;")
							||	(strIsEntity == "&quot;")
						) {
							break;
						}

						// ------------------------------------------------------------------------
						// はじめに見つかった付近のテキストを抽出
						// ------------------------------------------------------------------------
						var strAroundText = body.substring(
							iFoundPosition - iShowAroundBefore,
							iFoundPosition + iShowAroundAfter
						);

						// 切り出し後の先頭の文字がタイ語の声調記号の場合は除去する
						while (1) {
							if (strAroundText.substring(0, 1).match(/[\u0E31]|[\u0E47-\u0E4E]|[\u0E34-\u0E3A]/) != null) {
								strAroundText = strAroundText.substring(1);
							} else {
								break;
							}
						}
						arrSummaryText.push(strAroundText);
					}
				}

				// 複数指定されたすべての検索条件にヒット
				if (j == arrSearchText.length - 1) {

					// ヒット数カウントアップ
					iFound ++;

					// ページ範囲内かどうかの確認
					if (	(nPage * iShowResultCount >= iFound + 0)
						&&	(nPage * iShowResultCount - iShowResultCount < iFound + 0)
					) {
					} else {
						continue;
					}

					// サマリーを連結
					var strSummaryTexts = fncGetEncodeText(arrSummaryText.join("..."));

					// マーキング
					// 10種類のカラーバリエーションを循環
					var nMarkerColor = 0;
					for (var k = 0; k < nSearchTextLength; k++) {

						// 1桁数字を検索した場合にカラーバリエーションクラス名まで文字列置換されてしまうことを防ぐ
						// 0-9の代わりにU+2080(Subscript Zero)-U+2089(Subscript Nine)を使用する
						switch (nMarkerColor) {
							case 0:
								strMarkerColor = String.fromCharCode(0x2080); // "₀";
								break;
							case 1:
								strMarkerColor = String.fromCharCode(0x2081); // "₁";
								break;
							case 2:
								strMarkerColor = String.fromCharCode(0x2082); // "₂";
								break;
							case 3:
								strMarkerColor = String.fromCharCode(0x2083); // "₃";
								break;
							case 4:
								strMarkerColor = String.fromCharCode(0x2084); // "₄";
								break;
							case 5:
								strMarkerColor = String.fromCharCode(0x2085); // "₅";
								break;
							case 6:
								strMarkerColor = String.fromCharCode(0x2086); // "₆";
								break;
							case 7:
								strMarkerColor = String.fromCharCode(0x2087); // "₇";
								break;
							case 8:
								strMarkerColor = String.fromCharCode(0x2088); // "₈";
								break;
							case 9:
								strMarkerColor = String.fromCharCode(0x2089); // "₉";
								break;
						}

						var strSearchText = arrSearchText[k];

						// 検索キーワード内の実体参照文字列を一時的に1文字にパッキング
						strSearchText = strSearchText.replace(/&amp;/g, String.fromCharCode(0x02D6));	// "˖"
						strSearchText = strSearchText.replace(/&quot;/g, String.fromCharCode(0x02BA));	// "ʺ"
						strSearchText = strSearchText.replace(/&lt;/g, String.fromCharCode(0x02F1));	// "˱"
						strSearchText = strSearchText.replace(/&gt;/g, String.fromCharCode(0x02F2));	// "˲"

						// 用語集の場合は単語一致
						var strSearchTextParam = "(" + strSearchText + ")";

						// 見つかった文字列にマーキングするための正規表現インスタンス
						var rem = new RegExp(strSearchTextParam, "g" + strSearchOptionCaseSensitive);

						// サマリーテキスト内の実体参照文字列を一時的に1文字にパッキング
						strSummaryTexts = strSummaryTexts.replace(/&amp;/g, String.fromCharCode(0x02D6));
						strSummaryTexts = strSummaryTexts.replace(/&quot;/g, String.fromCharCode(0x02BA));
						strSummaryTexts = strSummaryTexts.replace(/&lt;/g, String.fromCharCode(0x02F1));
						strSummaryTexts = strSummaryTexts.replace(/&gt;/g, String.fromCharCode(0x02F2));

						// 見つかった文字列にマーキング実行
						strSummaryTexts = strSummaryTexts.replace(rem, function($1, $2, $3) {

							// マーキングタグ自体が検索条件に合致し文字列置換されることを防ぐ
							var strMarkupText = String.fromCharCode(0x2045) + strMarkerColor + $1 + String.fromCharCode(0x2046);
							return strMarkupText;
						});

						// パッキングした文字列を実体参照に復元
						strSummaryTexts = strSummaryTexts.replace(/\u02D6/g, "&amp;");
						strSummaryTexts = strSummaryTexts.replace(/\u02BA/g, "&quot;");
						strSummaryTexts = strSummaryTexts.replace(/\u02F1/g, "&lt;");
						strSummaryTexts = strSummaryTexts.replace(/\u02F2/g, "&gt;");

						// マーキング色の循環
						nMarkerColor++;
						if (nMarkerColor >= 10) {
							nMarkerColor = 0;
						}
					}

					// マーキング箇所にタグを適用
					var retb = new RegExp("\u2045([\u2080-\u2089])", "g");
					var rete = new RegExp("\u2046", "g");
//					strSummaryTexts = strSummaryTexts.replace(retb, "<span class=\"hit hit_$1\">");
//					strSummaryTexts = strSummaryTexts.replace(rete, "</span>");
					strSummaryTexts = strSummaryTexts.replace(retb, "<b>");
					strSummaryTexts = strSummaryTexts.replace(rete, "</b>");
					strSummaryTexts = strSummaryTexts.replace(/\u2080/g, "0");
					strSummaryTexts = strSummaryTexts.replace(/\u2081/g, "1");
					strSummaryTexts = strSummaryTexts.replace(/\u2082/g, "2");
					strSummaryTexts = strSummaryTexts.replace(/\u2083/g, "3");
					strSummaryTexts = strSummaryTexts.replace(/\u2084/g, "4");
					strSummaryTexts = strSummaryTexts.replace(/\u2085/g, "5");
					strSummaryTexts = strSummaryTexts.replace(/\u2086/g, "6");
					strSummaryTexts = strSummaryTexts.replace(/\u2087/g, "7");
					strSummaryTexts = strSummaryTexts.replace(/\u2088/g, "8");
					strSummaryTexts = strSummaryTexts.replace(/\u2089/g, "9");

					// ----------------------------------------------------------------------------
					// 段落記号をスタイリング
					// ----------------------------------------------------------------------------
					strSummaryTexts = strSummaryTexts.replace(/¶+/g, "");

					// ----------------------------------------------------------------------------
					// 検索結果のリンクとサマリー表示
					// ----------------------------------------------------------------------------
					if(arrResultTopics.join("") == ""){
						arrResultTopics.push("<ul class=\"list\">");
					}
					arrResultTopics.push("<li>");
					arrResultTopics.push("<a href=\"javascript:fncOpenTopic('" + toc_id + "', " + nPage + ");void(0);\">");
					arrResultTopics.push(title);
					arrResultTopics.push("</a>");
					arrResultTopics.push("<br/>");
					arrResultTopics.push("<span>");
					arrResultTopics.push("...");
					arrResultTopics.push(strSummaryTexts);
					arrResultTopics.push("...");
					arrResultTopics.push("</span>");
					arrResultTopics.push("</li>");
				}
			}
		}
		if(arrResultTopics.join("") != ""){
			arrResultTopics.push("</ul>");
		}

		// 検索キーワードの保持（結果リンククリック時に使用）
		arrResults.push("<input id=\"id_search_texts\" style=\"display:None;\" value=\"" + strSearchTexts + "\" />");

		// 検索結果をHTMLに貼り付け
		document.getElementById("id_search_results").innerHTML = arrResults.join("") + arrResultTopics.join("");
		document.getElementById("id_search_results").style.backgroundColor = "#FFFFFF";

		// 検索条件欄を選択状態にし、次に検索しやすいようにする
		//document.getElementById("id_search").select();

		// トップにスクロールする
		window.scroll(0,0);

		// ----------------------------------------------------------------------------------------
		// 検索結果ステータス処理
		// ----------------------------------------------------------------------------------------
		var arrStatus = new Array();

		arrStatus.push("<div class=\"turn-page\">");

		// 前の検索結果ページに戻るリンク
		if (nPage > 1) {
			arrStatus.push("<a onclick=\"fncDoSearch(" + (nPage - 1) + ");\" class=\"left\"><img src=\"../common/img/arrow_turnpage_l.png\" alt=\"" + fncGetResourceByResourceId("search_prev") + "\" /></a> ");
		} else {
			// 前のページがないときは表示しない
			//arrStatus.push("<button disabled class=\"disabled\">" + fncGetResourceByResourceId("search_prev") + "</button> ");
		}

		// 全体ページ数
		var nPageSize = parseInt(iFound / iShowResultCount);
		if (iFound % iShowResultCount != 0) {
			nPageSize ++;
		}

		// 各ページへのリンク作成
		var nStartPage = 1;
		var nEndPage = nPageSize;

		if (nPage - iPageRangeLeft > 1) {
			nStartPage = nPage - iPageRangeLeft;
		}

		// 検索数とページ数を表示
		if (document.getElementById("id_search_result_item")) {
			var arrResultItem = new Array();
			if (iFound == 0) {
				arrResultItem.push(fncGetNoneFoundMessage(strSearchTextsOriginal));
			} else {
				var iMaxview;
				if ((nPage)*parseInt(fncGetConstantByName("search_show_result_count")) > iFound) {
					iMaxview = iFound;
				}else{
					iMaxview = ((nPage)*parseInt(fncGetConstantByName("search_show_result_count")));
				}
				arrResultItem.push("<h2>" + fncGetSearchFoundMessage(strSearchTextsOriginal) + "<span>" + fncGetSearchCountMessage(nPage, iMaxview, iFound) + "</span></h2>");
			}
			document.getElementById("id_search_result_item").innerHTML = arrResultItem.join("");
		}

		// ページ数が5以下の場合
		if (iPageMaxRange >= nPageSize) {
			nEndPage = nPageSize;
			nStartPage = 1;

		// 現在ページから2ページ先が5ページ以下の場合
		} else if (nPage + iPageRangeRight <= iPageMaxRange) {
			nEndPage = iPageMaxRange;

		// 現在ページから2ページ先にページがない場合
		} else if (nPage + iPageRangeRight >= nPageSize) {
			nEndPage = nPageSize;
			nStartPage = nEndPage - iPageMaxRange + 1;
		} else {
			nEndPage = nPage + iPageRangeRight;
		}

		for (var i = nStartPage; i <= nEndPage; i++) {

			// 現在ページ
			if (nPage == i) {
				arrStatus.push("<a onclick=\"fncDoSearch(" + i + ");\" class=\"active\">" + i + "</a>");
			} else {
				arrStatus.push("<a onclick=\"fncDoSearch(" + i + ");\">" + i + "</a>");
			}
		}

		// 次の検索結果ページに戻るリンク
		if ((nPage + 1) <= nPageSize) {
			arrStatus.push(" <a onclick=\"fncDoSearch(" + (nPage + 1) + ");\" class=\"right\"><img src=\"../common/img/arrow_turnpage_r.png\" alt=\"" + fncGetResourceByResourceId("search_next") + "\" /></a>");
		} else {
			//arrStatus.push(" <button disabled class=\"disabled\">" + fncGetResourceByResourceId("search_next") + "</button>");
		}
		if (iFound != 0) {
			arrStatus.push("<div class=\"item-number\">" + fncGetSearchCountMessageBottom(nPage, iMaxview, iFound) + "</div>");
		}
		arrStatus.push("</div>");

		// 検索結果ステータスをHTMLに貼り付け
		document.getElementById("id_search_status").innerHTML = arrStatus.join("");

		if (strWindowType == "HOME") {

			// 検索キーワードの記憶
			var strSearchKeyword = document.getElementById("id_search_texts").value;
			fncSetCookie("SEARCH-KEYWORD", strSearchKeyword);
		}

		// 検索結果からジャンプしてきた場合、前回位置までスクロール
		var strSearchResultSetting = fncGetCookie("SEARCH-RESULT-SETTING");
		if ("" != strSearchResultSetting) {

			// Cookieから取得
			var arrSearchResultSetting = strSearchResultSetting.split(":");
			var nPrevPage = arrSearchResultSetting[0];
			var nPrevScroll = arrSearchResultSetting[1];
			if (nPrevPage == nPage) {

				// 前回検索したページと一致する場合、前回検索時のスクロール位置を復元
				if ("" != nPrevScroll && undefined != nPrevScroll) {

					// 一番下までスクロールされない場合があるためsetTimeout()を使用
					var ti = window.setTimeout("fncSearchResultScroll(" + nPrevScroll + ")", 10);
				}
			} else {

				// 上記以外は、スクロール位置を一番上に戻す
				fncSearchResultScroll(0);
			}
		} else {

			// 上記以外は、スクロール位置を一番上に戻す
			fncSearchResultScroll(0);
		}
	} catch (e) {
	}
}

function fncGetNoneFoundMessage(strSearchTexts) {
	var arrNoneFoundMessage = new Array();

	arrNoneFoundMessage.push("<h2>" + fncGetSearchFoundMessage(strSearchTexts) + "</h2>");
	arrNoneFoundMessage.push("<div class=\"guidance\">");
	arrNoneFoundMessage.push("<h3>" + fncGetResourceByResourceId("search_none_found_message_title") + "</h3>");
	arrNoneFoundMessage.push("<p><b>" + fncGetResourceByResourceId("search_none_found_message_body") + "</b></p>");
	arrNoneFoundMessage.push("<ul>");
	var i=1;
	while(fncGetResourceByResourceId("search_none_found_message_"+i) != "") {
		arrNoneFoundMessage.push("<li>" + fncGetResourceByResourceId("search_none_found_message_"+i) + "</li>");
		i++;
	}
	arrNoneFoundMessage.push("</ul>");
	arrNoneFoundMessage.push("</div>");

	document.getElementById("id_inner").style.display = "none";

	return arrNoneFoundMessage.join("");
}

function fncSearchResultScroll(nScroll) {
	document.getElementById("id_search_results").scrollTop = nScroll;
}

function fncOpenTopic(toc_id, nPage) {
	try {
		var search_texts = encodeURIComponent(document.getElementById("id_search").value);
		var strFilePath = toc_id + ".html?search=" + search_texts;

		// 表示中の検索結果のページ数とスクロール位置を設定
		fncSetSearchResultsInfo(nPage);

		window.open(strFilePath, "_self");
	} catch (e) {
		window.open(strFilePath);
	}
}

function fncSetSearchResultsInfo(nPage) {
	try {
		if (document.getElementById("id_search_results")) {
			// 用語以外の場合
			if (strWindowType != "GLOSSARY") {
				// 検索結果で表示中のページ数を保持
				fncSetCookie("SEARCH-RESULT-SETTING", nPage + ":" + document.getElementById("id_search_results").scrollTop);
			}
		}
	} catch (e) {
	}
}

function fncGetConstantByName(constant_name) {
	try {
		var o = eval(constant);
		return o[0][constant_name];
	} catch (e) {
	}
}

function fncGetCookiePrefixName() {
	try {
		return "EMANUAL-" + fncGetResourceByResourceId("pub_number") + "-";
	} catch (e) {
	}
}
function fncSetCookie(strName, strValue) {
	try {
		// 有効期限未設定のため、ブラウザを閉じるときにCookieを削除
		document.cookie = fncGetCookiePrefixName() + strName + "=" + encodeURIComponent(strValue) + ";path=/;";
	} catch (e) {
	}
}
function fncGetCookie(strName) {
	try {
		var arrCookie = document.cookie.split("; ");
		var iLoopLength = arrCookie.length;
		for (var i = 0; i < iLoopLength; i++) {
			var aCrumb = arrCookie[i].split("=");
			if (fncGetCookiePrefixName() + strName == aCrumb[0]) {
				if (aCrumb[1]) {
					return decodeURIComponent(aCrumb[1]);
				}
			}
		}
		return "";
	} catch (e) {
	}
}

// ------------------------------------------------------------------------------------------------
// マルチバイト区別しない正規表現の文字列を取得
// ------------------------------------------------------------------------------------------------
function fncConvertSearchText(strSearchText, bHtmlspecialchars) {
	try {
		var strConvert = "";
		var arrRegExp = fncGetRegExpArray();

		// 検索時に変換された&lt;&gt;&amp;を戻す
		strSearchText = strSearchText.replace(/&lt;/g ,'<');
		strSearchText = strSearchText.replace(/&gt;/g ,'>');
		strSearchText = strSearchText.replace(/&amp;/g ,'&');

		var nTextLength = strSearchText.length;

		// 入力された文字から変換対象となる文字を取得
		for (var i = 0; i < nTextLength; i++) {
			// 検索する文字列から1文字取得
			var character = strSearchText.substring(i, i + 1);
			var strRegExp = "";

			if (character.match(/[\u005C]/)) {
				// "\"の場合
				// 次の1文字を取得
				var characterNext = strSearchText.substring(i + 1, i + 2);
				if (character.match(/([$()\-^\\\|\[\]{},:+*.?])/)) {
					// エスケープされている場合
					strRegExp = fncGetRegExpString(character + characterNext, arrRegExp);
					// 処理した文字数分移動
					i++;
				}
			} else if (character.match(/[\uFF66-\uFF9F]/)) {
				// 半角カナの場合
				// 次の1文字を取得して濁点・半濁点の有無を確認
				var characterNext = strSearchText.substring(i + 1, i + 2);
				var bConvert = false;
				if (characterNext.match(/[\uFF9E-\uFF9F]/)) {
					// 濁点、半濁点を含む半角カナを全角カナに変換
					var singlebyteChar = character + characterNext;
					strRegExp = fncGetRegExpString(singlebyteChar, arrRegExp);
					if (strRegExp != singlebyteChar) {
						// 処理した文字数分移動
						i += characterNext.length;
					}
				}
			} else if (character.match(/[A-Za-z0-9]/)) {
				// 半角英数字の場合、「0xFEE0」を加算し全角英数字を取得
				var multibyteCode = character.charCodeAt(0) + 0xFEE0;
				var multibyteChar = String.fromCharCode(multibyteCode);
				strRegExp = "(" + character + "|" + multibyteChar + ")";
			} else if (character.match(/[\uFF21-\uFF3A\uFF41-\uFF5A\uFF10-\uFF19]/)) {
				// 全角英数字（Ａ-Ｚａ-ｚ０-９）の場合、「0xFEE0」を減算し半角英数時を取得
				var singlebyteCode = character.charCodeAt(0) - 0xFEE0;
				var singlebyteChar = String.fromCharCode(singlebyteCode);
				strRegExp = "(" + singlebyteChar + "|" + character + ")";
			}

			if (strRegExp == "") {
				// 変換していない場合は変換処理を実行
				strRegExp = fncGetRegExpString(character, arrRegExp);
			}

			strConvert += strRegExp;
		}

		if (bHtmlspecialchars) {
			// 指定がある場合は< > & を変換
			strConvert = strConvert.replace(/&/g ,'&amp;');
			strConvert = strConvert.replace(/</g ,'&lt;');
			strConvert = strConvert.replace(/>/g ,'&gt;');
		}

		return strConvert;

	} catch (e) {
	}
}

function fncGetRegExpString(strInputText, arrRegExp) {
	var strRegExp = strInputText;
	var strSep = fncGetRegExpSeparator();
	var nLength = arrRegExp.length;
	for (var nIndex = 0; nIndex < nLength; nIndex++) {
		// 変換テーブルから1行取得
		var strRegExpValue = arrRegExp[nIndex];
		var arrRegExpValue = strRegExpValue.split(strSep);
		var nLengthValue = arrRegExpValue.length;
		for (var nValue = 0; nValue < nLengthValue; nValue++) {
			var strValue = arrRegExpValue[nValue];
			if (strValue == strInputText) {
				// 変換対象の文字列と一致
				strRegExp = strRegExpValue.replace(strSep, "|");
				strRegExp = "(" + strRegExp + ")"
				break;
			}
		}
		if (strRegExp != strInputText) {
			// 変換済のため処理終了
			break;
		}
	}
	return strRegExp;
}

function fncGetRegExpArray() {

	var strSep = fncGetRegExpSeparator();

	// 1行に区別しない文字列を定義
	// 例: "ｱ" + strSep + "ア"
	// → "ｱ" と "ア" を区別しない
	var arrRegExpString = new Array(
		"\uFF71" + strSep + "\u30A2",				// "ｱ" "ア"
		"\uFF72" + strSep + "\u30A4",				// "ｲ" "イ"
		"\uFF73" + strSep + "\u30A6",				// "ｳ" "ウ"
		"\uFF74" + strSep + "\u30A8",				// "ｴ" "エ"
		"\uFF75" + strSep + "\u30AA",				// "ｵ" "オ"
		"\uFF76" + strSep + "\u30AB",				// "ｶ" "カ"
		"\uFF77" + strSep + "\u30AD",				// "ｷ" "キ"
		"\uFF78" + strSep + "\u30AF",				// "ｸ" "ク"
		"\uFF79" + strSep + "\u30B1",				// "ｹ" "ケ"
		"\uFF7A" + strSep + "\u30B3",				// "ｺ" "コ"
		"\uFF7B" + strSep + "\u30B5",				// "ｻ" "サ"
		"\uFF7C" + strSep + "\u30B7",				// "ｼ" "シ"
		"\uFF7D" + strSep + "\u30B9",				// "ｽ" "ス"
		"\uFF7E" + strSep + "\u30BB",				// "ｾ" "セ"
		"\uFF7F" + strSep + "\u30BD",				// "ｿ" "ソ"
		"\uFF80" + strSep + "\u30BF",				// "ﾀ" "タ"
		"\uFF81" + strSep + "\u30C1",				// "ﾁ" "チ"
		"\uFF82" + strSep + "\u30C4",				// "ﾂ" "ツ"
		"\uFF83" + strSep + "\u30C6",				// "ﾃ" "テ"
		"\uFF84" + strSep + "\u30C8",				// "ﾄ" "ト"
		"\uFF85" + strSep + "\u30CA",				// "ﾅ" "ナ"
		"\uFF86" + strSep + "\u30CB",				// "ﾆ" "ニ"
		"\uFF87" + strSep + "\u30CC",				// "ﾇ" "ヌ"
		"\uFF88" + strSep + "\u30CD",				// "ﾈ" "ネ"
		"\uFF89" + strSep + "\u30CE",				// "ﾉ" "ノ"
		"\uFF8A" + strSep + "\u30CF",				// "ﾊ" "ハ"
		"\uFF8B" + strSep + "\u30D2",				// "ﾋ" "ヒ"
		"\uFF8C" + strSep + "\u30D5",				// "ﾌ" "フ"
		"\uFF8D" + strSep + "\u30D8",				// "ﾍ" "ヘ"
		"\uFF8E" + strSep + "\u30DB",				// "ﾎ" "ホ"
		"\uFF8F" + strSep + "\u30DE",				// "ﾏ" "マ"
		"\uFF90" + strSep + "\u30DF",				// "ﾐ" "ミ"
		"\uFF91" + strSep + "\u30E0",				// "ﾑ" "ム"
		"\uFF92" + strSep + "\u30E1",				// "ﾒ" "メ"
		"\uFF93" + strSep + "\u30E2",				// "ﾓ" "モ"
		"\uFF94" + strSep + "\u30E4",				// "ﾔ" "ヤ"
		"\uFF95" + strSep + "\u30E6",				// "ﾕ" "ユ"
		"\uFF96" + strSep + "\u30E8",				// "ﾖ" "ヨ"
		"\uFF97" + strSep + "\u30E9",				// "ﾗ" "ラ"
		"\uFF98" + strSep + "\u30EA",				// "ﾘ" "リ"
		"\uFF99" + strSep + "\u30EB",				// "ﾙ" "ル"
		"\uFF9A" + strSep + "\u30EC",				// "ﾚ" "レ"
		"\uFF9B" + strSep + "\u30ED",				// "ﾛ" "ロ"
		"\uFF9C" + strSep + "\u30EF",				// "ﾜ" "ワ"
		"\uFF66" + strSep + "\u30F2",				// "ｦ" "ヲ"
		"\uFF9D" + strSep + "\u30F3",				// "ﾝ" "ン"
		"\uFF67" + strSep + "\u30A1",				// "ｧ" "ァ"
		"\uFF68" + strSep + "\u30A3",				// "ｨ" "ィ"
		"\uFF69" + strSep + "\u30A5",				// "ｩ" "ゥ"
		"\uFF6A" + strSep + "\u30A7",				// "ｪ" "ェ"
		"\uFF6B" + strSep + "\u30A9",				// "ｫ" "ォ"
		"\uFF6F" + strSep + "\u30C3",				// "ｯ" "ッ"
		"\uFF6C" + strSep + "\u30E3",				// "ｬ" "ャ"
		"\uFF6D" + strSep + "\u30E5",				// "ｭ" "ュ"
		"\uFF6E" + strSep + "\u30E7",				// "ｮ" "ョ"
		"\uFF73\uFF9E" + strSep + "\u30F4",				// "ｳﾞ" "ヴ"
		"\uFF76\uFF9E" + strSep + "\u30AC",				// "ｶﾞ" "ガ"
		"\uFF77\uFF9E" + strSep + "\u30AE",				// "ｷﾞ" "ギ"
		"\uFF78\uFF9E" + strSep + "\u30B0",				// "ｸﾞ" "グ"
		"\uFF79\uFF9E" + strSep + "\u30B2",				// "ｹﾞ" "ゲ"
		"\uFF7A\uFF9E" + strSep + "\u30B4",				// "ｺﾞ" "ゴ"
		"\uFF7B\uFF9E" + strSep + "\u30B6",				// "ｻﾞ" "ザ"
		"\uFF7C\uFF9E" + strSep + "\u30B8",				// "ｼﾞ" "ジ"
		"\uFF7D\uFF9E" + strSep + "\u30BA",				// "ｽﾞ" "ズ"
		"\uFF7E\uFF9E" + strSep + "\u30BC",				// "ｾﾞ" "ゼ"
		"\uFF7F\uFF9E" + strSep + "\u30BE",				// "ｿﾞ" "ゾ"
		"\uFF80\uFF9E" + strSep + "\u30C0",				// "ﾀﾞ" "ダ"
		"\uFF81\uFF9E" + strSep + "\u30C2",				// "ﾁﾞ" "ヂ"
		"\uFF82\uFF9E" + strSep + "\u30C5",				// "ﾂﾞ" "ヅ"
		"\uFF83\uFF9E" + strSep + "\u30C7",				// "ﾃﾞ" "デ"
		"\uFF84\uFF9E" + strSep + "\u30C9",				// "ﾄﾞ" "ド"
		"\uFF8A\uFF9E" + strSep + "\u30D0",				// "ﾊﾞ" "バ"
		"\uFF8B\uFF9E" + strSep + "\u30D3",				// "ﾋﾞ" "ビ"
		"\uFF8C\uFF9E" + strSep + "\u30D6",				// "ﾌﾞ" "ブ"
		"\uFF8D\uFF9E" + strSep + "\u30D9",				// "ﾍﾞ" "ベ"
		"\uFF8E\uFF9E" + strSep + "\u30DC",				// "ﾎﾞ" "ボ"
		"\uFF8A\uFF9F" + strSep + "\u30D1",				// "ﾊﾟ" "パ"
		"\uFF8B\uFF9F" + strSep + "\u30D4",				// "ﾋﾟ" "ピ"
		"\uFF8C\uFF9F" + strSep + "\u30D7",				// "ﾌﾟ" "プ"
		"\uFF8D\uFF9F" + strSep + "\u30DA",				// "ﾍﾟ" "ペ"
		"\uFF8E\uFF9F" + strSep + "\u30DD",				// "ﾎﾟ" "ポ"

		"\u0021" + strSep + "\uFF01",					// ! ！
		"\u0022" + strSep + "\u201D",					// " ”
		"\u0023" + strSep + "\uFF03",					// # ＃
		"\u005C\u0024" + strSep + "\uFF04",				// \$ ＄
		"\u0025" + strSep + "\uFF05",					// % ％
		"\u0026" + strSep + "\uFF06",					// & ＆
		"\u0027" + strSep + "\u2019",					// ' ’
		"\u005C\u0028" + strSep + "\uFF08",				// \( （
		"\u005C\u0029" + strSep + "\uFF09",				// \) ）
		"\u005C\u002A" + strSep + "\uFF0A",				// \* ＊
		"\u005C\u002B" + strSep + "\uFF0B",				// \+ ＋
		"\u005C\u002C" + strSep + "\uFF0C",				// \, ，
		"\u005C\u002D" + strSep + "\uFF0D",				// \- －
		"\u005C\u002E" + strSep + "\uFF0E",				// \. ．
		"\u002F" + strSep + "\uFF0F",					// / ／
		"\u005C\u003A" + strSep + "\uFF1A",				// \: ：
		"\u003B" + strSep + "\uFF1B",					// ; ；
		"\u003C" + strSep + "\uFF1C",					// < ＜
		"\u003D" + strSep + "\uFF1D",					// = ＝
		"\u003E" + strSep + "\uFF1E",					// > ＞
		"\u005C\u003F" + strSep + "\uFF1F",				// \? ？
		"\u0040" + strSep + "\uFF20",					// @ ＠
		"\u005C\u005B" + strSep + "\uFF3B",				// \[ ［
		"\u005C\u005C" + strSep + "\uFFE5",				// \\ ￥
		"\u005C\u005D" + strSep + "\uFF3D",				// \] ］
		"\u005C\u005E" + strSep + "\uFF3E",				// \^ ＾
		"\u005F" + strSep + "\uFF3F",					// _ ＿
		"\u0060" + strSep + "\u2018",					// ` ‘
		"\u005C\u007B" + strSep + "\uFF5B",				// \{ ｛
		"\u005C\u007C" + strSep + "\uFF5C",				// \| ｜
		"\u005C\u007D" + strSep + "\uFF5D",				// \} ｝
		"\u007E" + strSep + "\uFF5E",					// ~ ～
		"\uFF61" + strSep + "\u3002",					// ｡ 。
		"\uFF62" + strSep + "\u300C",					// ｢ 「
		"\uFF63" + strSep + "\u300D",					// ｣ 」
		"\uFF64" + strSep + "\u3001",					// ､ 、
		"\uFF65" + strSep + "\u30FB"					// ･ ・

	);

	return arrRegExpString;
}

function fncGetRegExpSeparator() {
	return "###Separator###";
}

function fncGetSearchFoundMessage(strSearchTexts){
	return fncGetResourceByResourceId("search_found_message_1_prefix") + fncGetResourceByResourceId("search_word_open") + strSearchTexts + fncGetResourceByResourceId("search_word_close") + fncGetResourceByResourceId("search_found_message_1_suffix");
}

function fncGetSearchCountMessage(nPage, iMaxview, iFound){
	return fncGetResourceByResourceId("search_found_count_message_open") + fncGetResourceByResourceId("search_found_count_message_prefix") + ((nPage-1)*parseInt(fncGetConstantByName("search_show_result_count"))+1) + fncGetResourceByResourceId("search_found_sub_message_to") + iMaxview + fncGetResourceByResourceId("search_found_sub_message_1") + iFound + fncGetResourceByResourceId("search_found_count_message_suffix") + fncGetResourceByResourceId("search_found_count_message_close");
}

function fncGetSearchCountMessageBottom(nPage, iMaxview, iFound){
	return fncGetResourceByResourceId("search_found_count_message_prefix") + ((nPage-1)*parseInt(fncGetConstantByName("search_show_result_count"))+1) + fncGetResourceByResourceId("search_found_sub_message_to") + iMaxview + fncGetResourceByResourceId("search_found_sub_message_1") + iFound + fncGetResourceByResourceId("search_found_count_message_suffix");
}

function fncGetEncodeText(strText){
	var strConvert = strText;
	if(strConvert != null){
		strConvert = strConvert.replace(/&/g ,'&amp;');
		strConvert = strConvert.replace(/</g ,'&lt;');
		strConvert = strConvert.replace(/>/g ,'&gt;');
	}
	return strConvert;
}

String.prototype.trim = function() {
	return this.replace(/(^\s+|\s+$)/g ,"");
};