#!/bin/sh

function SetRedDbEnv()
{
	APP_DB=Red.db
	APP_EPG_DB=RedEpg.db
	RUN_DB_PATH=/tmp
	SHADOW_DB_PATH=/mnt/flash/Resource
	DB_SCHEMA=/Resource/Db/Red.sql
	EPG_DB_SCHEMA=/Resource/Db/RedEpg.sql
	APP_DB_DATA=Red.sql
	SCHEDULE_DATA=RedSchedule.sql
	RAW_FILE=EpgRaw.dat
	ALL_RAW_FILE="*Raw*.dat"
}

function MakeDbChecksum()
{
	DB_FILE_PATH=$1
	DB_CHECKSUM=`echo ".schema" | /Bin/sqlite3 $DB_FILE_PATH | md5sum | awk '{ print $1}'`
}

function InitDb()
{	
	DB_FILE_PATH=$1
	DB_SCHEMA_PATH=$2
	echo "InitDb $DB_FILE_PATH $DB_SCHEMA_PATH"

	rm -f $DB_FILE_PATH
	cat $DB_SCHEMA_PATH | /Bin/sqlite3 $DB_FILE_PATH
	MakeDbChecksum $DB_FILE_PATH
	echo $DB_CHECKSUM > "$DB_FILE_PATH".md5
}

function CheckDb()
{
	DB_FILE_PATH=$1
	SAVED=`cat "$DB_FILE_PATH".md5`
	if [ -z $SAVED ]; then
		echo "no saved checksum"
		return 0
	fi
	
	MakeDbChecksum $DB_FILE_PATH
	CALCULATED=$DB_CHECKSUM
	if [ "$SAVED" == "$CALCULATED" ]; then
		echo "OK"
		return 1
	else
		echo "Invalid"
		return 0
	fi
}

function MakeAppDb()
{
	rm -f $RUN_DB_PATH/$APP_DB
	InitDb $SHADOW_DB_PATH/$APP_DB $DB_SCHEMA
	sync
}

function MakeAppEpgDb()
{
	InitDb $RUN_DB_PATH/$APP_EPG_DB $EPG_DB_SCHEMA
}

function BackupAppDbData()
{
	echo "backup app data"
	echo ".dump" | /Bin/sqlite3 $RUN_DB_PATH/$APP_DB > $SHADOW_DB_PATH/$APP_DB_DATA
	sync;
}

function BackupAppEpgDb()
{
	echo "backup app epg db"
	cp $RUN_DB_PATH/$APP_EPG_DB $SHADOW_DB_PATH/$APP_EPG_DB
	md5sum $SHADOW_DB_PATH/$APP_EPG_DB > $SHADOW_DB_PATH/$APP_EPG_DB.md5
	sync;
}

function BackupAppEpgRawData()
{
	echo "backup epg raw data"
	cp $RUN_DB_PATH/$ALL_RAW_FILE $SHADOW_DB_PATH/
	md5sum $SHADOW_DB_PATH/$ALL_RAW_FILE > $SHADOW_DB_PATH/$RAW_FILE.md5
	sync;
}

function RestoreAppEpgDb()
{
	echo "restore app epg db"
	if [ ! -f $SHADOW_DB_PATH/$APP_EPG_DB ]; then
		echo "no epg db file"
		return 1
	fi
	
	if [ ! -f $SHADOW_DB_PATH/$APP_EPG_DB.md5 ]; then
		echo "no checksum file for epg db file"
		return 2
	fi
	
	SAVED_CHECKSUM=`cat $SHADOW_DB_PATH/$APP_EPG_DB.md5`
	echo "SAVED_CHECKSUM: $SAVED_CHECKSUM"
	CALCULATED_CHECKSUM=`md5sum $SHADOW_DB_PATH/$APP_EPG_DB`
	echo "CALCULATED_CHECKSUM: $CALCULATED_CHECKSUM"
	
	if [ "$SAVED_CHECKSUM" != "$CALCULATED_CHECKSUM" ]; then
		echo "invalid checksum"
		return 3
	fi
	
	cp $SHADOW_DB_PATH/$APP_EPG_DB $RUN_DB_PATH/$APP_EPG_DB
	MakeDbChecksum $RUN_DB_PATH/$APP_EPG_DB
	CHECKSUM=$DB_CHECKSUM
	echo $CHECKSUM > "$RUN_DB_PATH/$APP_EPG_DB".md5
	return 0
}

function RestoreAppEpgRawData()
{
	echo "restore app epg raw data"
	if [ ! -f $SHADOW_DB_PATH/$RAW_FILE.md5 ]; then
		echo "no checksum file for epg db file"
		return 2
	fi
	
	SAVED_CHECKSUM=`cat $SHADOW_DB_PATH/$RAW_FILE.md5`
	echo "SAVED_CHECKSUM: $SAVED_CHECKSUM"
	CALCULATED_CHECKSUM=`md5sum $SHADOW_DB_PATH/$ALL_RAW_FILE`
	echo "CALCULATED_CHECKSUM: $CALCULATED_CHECKSUM"
	
	if [ "$SAVED_CHECKSUM" != "$CALCULATED_CHECKSUM" ]; then
		echo "invalid checksum"
		return 3
	fi
	
	cp $SHADOW_DB_PATH/$ALL_RAW_FILE $RUN_DB_PATH/
	return 0
}

function RestoreAppDbData()
{
	if [ -f $SHADOW_DB_PATH/$APP_DB_DATA ]; then
		cat $SHADOW_DB_PATH/$APP_DB_DATA | sqlite3 $SHADOW_DB_PATH/$APP_DB
		MakeDbChecksum $SHADOW_DB_PATH/$APP_DB
		CHECKSUM=$DB_CHECKSUM
		echo $CHECKSUM > "$SHADOW_DB_PATH/$APP_DB".md5
		sync
	fi
}

function CheckAppDb()
{
	CheckDb $SHADOW_DB_PATH/$APP_DB
	RESULT=$?
	if [ "$RESULT" -eq 1 ]; then
		return 1
	fi
	
	echo "invalid $SHADOW_DB_PATH/$APP_DB"
	if [ -f $SHADOW_DB_PATH/$APP_DB_DATA ]
	then
		echo "app db will be restored from backup data"
		RestoreAppDbData
	else
		echo "no backup data, so app db will be initialzed"
		MakeAppDb
	fi
	
	cp -f $SHADOW_DB_PATH/$APP_DB $RUN_DB_PATH/
}

function BackupAppScheduleData()
{
	echo "BackupDb"
	echo ".dump schedule" | sqlite3 $RUN_DB_PATH/$APP_EPG_DB | grep 'INSERT' > $SHADOW_DB_PATH/$SCHEDULE_DATA
	echo ".dump schedule_group" | sqlite3 $RUN_DB_PATH/$APP_EPG_DB | grep 'INSERT' >> $SHADOW_DB_PATH/$SCHEDULE_DATA
	echo ".dump schedule_group_crid" | sqlite3 $RUN_DB_PATH/$APP_EPG_DB | grep 'INSERT' >> $SHADOW_DB_PATH/$SCHEDULE_DATA
	sync;
}

function RestoreAppScheduleData()
{
	if [ -f $SHADOW_DB_PATH/$SCHEDULE_DATA ]; then
		cat $SHADOW_DB_PATH/$SCHEDULE_DATA | sqlite3 $RUN_DB_PATH/$APP_EPG_DB
	fi
}

function CheckAppEpgDb()
{
	CheckDb $RUN_DB_PATH/$APP_EPG_DB
	RESULT=$?
	if [ "$RESULT" -eq 1 ]; then
		return 1
	fi
	
	echo "invalid $RUN_DB_PATH/$APP_EPG_DB"
	MakeAppEpgDb
	RestoreAppScheduleData
}
