#!/bin/sh

source /Bin/DiskCommon.sh
source /Bin/RedDb.sh

function SetHardwareEnv()
{
	echo "pmtest: usb off"
	/bin/pmtest usb 0
#	/bin/pmtest sata 0
}

function SetRedEnv()
{
	source /Bin/SetEnv.sh 
	APP_ON=Red
	APP_SB=RedTerminator
	APP_MODE=/mnt/flash/Mode
	POWER_ON_FLAG=/tmp/PowerOn
	SetRedDbEnv
}

function InitBcm()
{
	/Bin/InitBcm.sh 
}

function CheckDisks()
{
	echo "MEDIA_PATH: $MEDIA_PATH"
	DISKS=`ls $MEDIA_PATH`
	echo "DISKS: $DISKS"
	for DISK in $DISKS
	do
		echo "DISK: $DISK"
		MOUNTED=`cat /proc/mounts|grep $DISK|wc -l`
		echo "MOUNTED: $MOUNTED"
		if [ $MOUNTED -eq 1 ]
		then
				umount $MEDIA_PATH/$DISK
				echo "$MEDIA_PATH/$DISK is unmounted"
		fi
		rmdir $MEDIA_PATH/$DISK
		echo "$MEDIA_PATH/$DISK is removed"
	done
	echo "CheckDisks is done"
}

function CheckLogsCount()
{
	LOG_PATH=$1
	MAX_LOGS_COUNT=$2
	echo "LOG_PATH: $LOG_PATH, MAX_LOGS_COUNT: $MAX_LOGS_COUNT"

	LOGS_LIST=`ls -d $LOG_PATH/0*`
	LOGS_COUNT=`echo $LOGS_LIST|wc -w`
	echo "LOGS_COUNT: $LOGS_COUNT"
	if [ "$LOGS_COUNT" -le "$MAX_LOGS_COUNT" ]; then
		echo "no need to delete"
		return 0
	fi

	(( COUNT_TO_DELETE = LOGS_COUNT - $MAX_LOGS_COUNT ))
	echo "COUNT_TO_DELETE: $COUNT_TO_DELETE"
	COUNT_DELETED=0
	for LOG in $LOGS_LIST
	do
	  echo "LOG: $LOG"
	  rm -fr $LOG
	  (( COUNT_DELETED += 1 ))
	  echo "$LOG is deleted. deleted: $COUNT_DELETED, to delete: $COUNT_TO_DELETE"

	  if [ "$COUNT_DELETED" -ge "$COUNT_TO_DELETE" ]; then
		  echo "old logs have been deleted"
		  break
	  fi
	done
}

function CheckLogging()
{
	DISK_TO_LOG=""
	IS_LOGGABLE=""

	LOGGING_ENABLE=`cat /mnt/flash/Resource/Red.conf|grep EnableLogging|awk '{print $3}'`
	echo "LOGGING_ENABLE: $LOGGING_ENABLE"
	if [ -z "$LOGGING_ENABLE" ] || [ "$LOGGING_ENABLE" -ne 1 ]; then
		return 1
	fi

	/Bin/CheckDiskInfo.sh 1
	DISK_TO_LOG=`cat $DISK_INFO_FILE|grep '2 = xfs'|sed -n '1p'|awk '{print $1}'`
	echo "DISK_TO_LOG: $DISK_TO_LOG"
	if [ -z "$DISK_TO_LOG" ]; then
		echo "no disk to log"
		return 2
	fi

	if [ -f /tmp/ClearSysLog ]; then
		mkfs.xfs -f /dev/$DISK_TO_LOG
		rm -f /tmp/ClearSysLog
	fi

	mkdir -p $MEDIA_PATH/SysLog
	mount -t xfs /dev/$DISK_TO_LOG $MEDIA_PATH/SysLog
	IS_LOGGABLE=`cat /proc/mounts|grep $DISK_TO_LOG|wc -l`
	if [ "$IS_LOGGABLE" -ne 1 ]; then
		return 3
	fi

	# delete old logs when not enough space
	MAX_LOGS_COUNT=20
	CheckLogsCount $MEDIA_PATH/SysLog $MAX_LOGS_COUNT

	return 0
}

function ArchiveLog()
{
	if [ "$IS_LOGGABLE" -eq 1 ]; then
		ORDER_FILE=$MEDIA_PATH/SysLog/order
		if [ -f $ORDER_FILE ]; then
			ORDER=`cat $ORDER_FILE`
		else
			ORDER=0
		fi

		((ORDER += 1))
		echo $ORDER > $ORDER_FILE

		ORDER=`printf %08d $ORDER`
		ARCHIVE_NAME=`date '+%Y%m%d-%H%M%S'`
		ARCHIVE_DIR=$MEDIA_PATH/SysLog/$ORDER.$ARCHIVE_NAME
		echo "ARCHIVE_DIR: $ARCHIVE_DIR"

		mkdir -p $ARCHIVE_DIR
		mv $MEDIA_PATH/SysLog/*.log $ARCHIVE_DIR/
		cp -f /tmp/*.db $ARCHIVE_DIR/
	fi
}

function CheckExecuter()
{
	EXCEUTER_PID=`pidof Executer`
	if [ ! -z "$EXCEUTER_PID" ]; then
		killall Executer 
		sleep 1
	fi

	/Bin/Executer 0 &
}

function Main()
{
 	if [ -f $POWER_ON_FLAG ]; then
# 		RestoreAppEpgDb
 		RestoreAppEpgRawData
 	fi

	SetHardwareEnv
	CheckExecuter

	LOOP_COUNT=0
	while [ 1 ];
	do		
		((LOOP_COUNT += 1))
		echo "### Red loop count: $LOOP_COUNT ###"
		echo "$LOOP_COUNT" > /tmp/LoopCount

		CheckAppDb
		CheckAppEpgDb
		CheckLogging
		RESULT_OF_LOGGING=$?
		echo "RESULT_OF_LOGGING: $RESULT_OF_LOGGING"

		echo "# run ON Application: Red"
		if [ "$RESULT_OF_LOGGING" -eq 0 ]; then
			/Bin/$APP_ON > $MEDIA_PATH/SysLog/Red.log 2>&1
			ArchiveLog
		else
			/Bin/$APP_ON
		fi

		echo "APP_SB" > $APP_MODE; sync
		
		killall KillRed.sh

#		BackupAppEpgDb
		BackupAppEpgRawData

		echo "# kill check disk to make HDD sleep"
		StopCheckDiskInfo
		CheckDisks
		echo "# make HDD sleep"
#		hdparm -y /dev/sda
		sdparm --command=stop /dev/sda
		sync
		echo "#usb power off"
		pmtest usb 0
#		pmtest sata 0

		echo "# run StandBy Application: RedTerminator"
		/Bin/$APP_SB #| tee /mnt/nfs/Temp/RedTerminator.log 2>&1
		killall KillRed.sh
		
		rm -f $APP_MODE; sync
		
		echo ""
	done
}

################
# Start Main ###
################

#fsck.ext3 /dev/sda2

SetRedEnv
InitBcm
Main
