#!/bin/sh

NETWORK_SH=/Bin/Network.sh
NETWORK_CONF=Network.conf
TMP_NETWORK_CONF=/tmp/$NETWORK_CONF
RESOURCE_NETWORK_CONF=/mnt/flash/Resource/$NETWORK_CONF

function DoDefault()
{
	$NETWORK_SH PROTO=dhcp SAVE=1
#	$NETWORK_SH PROTO=static 192.168.11.100 NET=255.255.255.0 GW=192.168.11.1 SAVE=1
}

function InitStatic()
{
	VALUE=$(cat $TMP_NETWORK_CONF | grep IPADDR)
	IP=${VALUE:7}
	echo "IP: $IP"

	VALUE=$(cat $TMP_NETWORK_CONF | grep NETMASK)
	NET=${VALUE:8}
	echo "NET: $NET"

	VALUE=$(cat $TMP_NETWORK_CONF | grep GWADDR)
	GW=${VALUE:7}
	echo "GW: $GW"

	VALUE=$(cat $TMP_NETWORK_CONF | grep DNS)
	DNS=${VALUE:4}
	echo "DNS: $DNS"
	
	$NETWORK_SH PROTO=static IP=$IP NET=$NET GW=$GW DNS=$DNS
}

function InitNfs()
{
	VALUE=$(cat $TMP_NETWORK_CONF | grep NFSSVR)
	NFSSVR=${VALUE:7}
	echo "NFSSVR: $NFSSVR"

	VALUE=$(cat $TMP_NETWORK_CONF | grep NFSDIR)
	NFSDIR=${VALUE:7}
	echo "NFSDIR: $NFSDIR"

	if [ ! -z "$NFSSVR" ] && [ ! -z "$NFSDIR" ]; then
		mount -t nfs $NFSSVR:$NFSDIR /mnt/nfs -o nolock,rsize=32768,wsize=32768,tcp
	fi
}

############################################
# main
if [ ! -f $RESOURCE_NETWORK_CONF ]; then
	DoDefault
	exit 0
fi

cp -f $RESOURCE_NETWORK_CONF $TMP_NETWORK_CONF

VALUE=$(cat $TMP_NETWORK_CONF | grep BOOTPROTO)
PROTO=${VALUE:10}
echo "PROTO: $PROTO"

if [ "$PROTO" == static ]; then
	InitStatic
else
	$NETWORK_SH PROTO=dhcp 
fi

InitNfs

rm -f $TMP_NETWORK_CONF
#
############################################