#!/bin/sh

source /Bin/DiskCommon.sh

PARTITIONS_COUNT=10

function PrintUsage()
{
	echo "Usage: `basename $0` device"
	echo " device: /dev/sda, /dev/sdb, ..."
}

function SetEnv()
{
	DISK_NAME=$1
	echo "$DISK_NAME, $1"
}

function MakePartition()
{
	DISK_SHORT_NAME=${DISK_NAME:5}
	echo "DISK_SHORT_NAME: $DISK_SHORT_NAME"
	TOTAL_SIZE_IN_KB=`cat /proc/partitions | grep "$DISK_SHORT_NAME\b" | awk '{print $3}'`
	if [ -z "$TOTAL_SIZE_IN_KB" ]; then
		echo "invalid partition size"
		return 0
	fi
	
#	echo "TOTAL_SIZE_IN_KB: $TOTAL_SIZE_IN_KB"
	((FIRST_SIZE_IN_KB = $TOTAL_SIZE_IN_KB - 1048576))
#	echo "FIRST_SIZE_IN_KB: $FIRST_SIZE_IN_KB"

	FDISK_INPUT="n\np\n1\n\n+""$FIRST_SIZE_IN_KB""K\nn\np\n2\n\n\nw\n"
#	FDISK_INPUT="n\np\n1\n\n+8192M\nn\np\n2\n\n\nw\n"
	echo "3: $FDISK_INPUT"
	
	eval echo -e '$FDISK_INPUT' | fdisk $DISK_NAME
	return 1
}

function BuildPartitions()
{
    tryCount=5

    while [ "$tryCount" -gt "1" ]
    do
		DeleteAllPartitions
		sleep 1
		MakePartition
		RESULT=$?
		if [ "$RESULT" -eq 0 ]; then
			echo "fail to build partition"
			return 0
		fi

		GetPartitionsCount
		echo "$PARTITIONS_COUNT"
		if [ "$PARTITIONS_COUNT" -eq "2" ]
		then
			break;
		fi

		((tryCount -= 1))
	done
	
	return 1
}

if [ -z "$1" ]
then
	PrintUsage
	exit 0
fi

SetEnv $1
echo "start" > $INIT_STATUS_FILE
BuildPartitions
RESULT=$?
if [ "$RESULT" -eq 0 ]; then
	echo "fail to init HDD"
	exit 0
fi

FormatDisk "$DISK_NAME" "1"
sleep 1
FormatDisk "$DISK_NAME" "2"
sleep 1
rm -f $INIT_STATUS_FILE
