#!/bin/sh

# this is script used in other scripts

DISK_INFO_FILE=/tmp/DiskInfo.conf
TMP_DISK_INFO_FILE=/tmp/DiskInfo.conf~
INIT_STATUS_FILE=/tmp/INIT_DISK
REPAIR_STATUS_FILE=/tmp/REPAIR_DISK
MEDIA_PATH=/Media

function GetPartitionsCount()
{
	PARTITIONS_COUNT=`fdisk -l $DISK_NAME | grep $DISK_NAME | wc -l`
	((PARTITIONS_COUNT -= 1))
	echo "PARTITIONS_COUNT: $PARTITIONS_COUNT"
}

function DeletePartitions()
{
	GetPartitionsCount
	
	LOOP_COUNT=$PARTITIONS_COUNT
	echo "LC1: $LOOP_COUNT"
	FDISK_INPUT=""
	while [ "$LOOP_COUNT" -gt "1" ]
	do
			FDISK_INPUT="$FDISK_INPUT""d\n""$LOOP_COUNT\n"
			((LOOP_COUNT -= 1))
			echo "LC1: $LOOP_COUNT"
	done

	echo "1: $FDISK_INPUT"

	if [ "$LOOP_COUNT" -eq "1" ]
	then	
			FDISK_INPUT="$FDISK_INPUT""d\nw\n"
	fi

	echo "2: $FDISK_INPUT"
	eval echo -e '$FDISK_INPUT' | fdisk $DISK_NAME
}

function DeleteAllPartitions()
{
    DELETE_ALL_PARTITION_CMD=""
    COUNT=10
    while [ "$COUNT" -gt "0" ]
    do
	DELETE_ALL_PARTITION_CMD="$DELETE_ALL_PARTITION_CMD""d\n""$COUNT""\n"
	((COUNT -= 1))
    done

    DELETE_ALL_PARTITION_CMD="$DELETE_ALL_PARTITION_CMD""w\n"

    echo $DELETE_ALL_PARTITION_CMD
    eval echo -e '$DELETE_ALL_PARTITION_CMD' | fdisk $DISK_NAME
}

function RepairXfs()
{
	echo "xfs_repair $1"
	xfs_repair $1 > $REPAIR_STATUS_FILE
	IS_ERROR=$?
	echo "error = $IS_ERROR"
	if [ 0 == "$IS_ERROR" ]; then
		echo "Normal Repair OK"
	else
		echo "xfs_repair -L $1"
		xfs_repair -L $1 > $REPAIR_STATUS_FILE
	#	sleep 1
	fi

	rm -f $REPAIR_STATUS_FILE	
}

function FormatDisk()
{
    disk=$1
    num=$2
    partition="$disk$num"
    mkfs.xfs -l lazy-count=0 -f $partition
}

function StartCheckDiskInfo()
{
	rm -f $DISK_INFO_FILE $TMP_DISK_INFO_FILE
	/Bin/CheckDiskInfo.sh &
}

function StopCheckDiskInfo()
{
	ps | grep CheckDiskInfo.sh | grep /bin/sh | awk '{print $1}' | xargs kill;
	killall sleep;
	
	DISK_CHECK_PID=`ps | grep CheckDiskInfo.sh | grep /bin/sh | awk '{print $1}'`
	if [ ! -z "$DISK_CHECK_PID" ]; then
		kill -9 $DISK_CHECK_PID
		killall sleep
	fi
	
	rm -f $DISK_INFO_FILE $TMP_DISK_INFO_FILE
}

