#!/bin/sh

function SetEnv()
{
	export LD_LIBRARY_PATH=/Lib
	DISK_INFO_FILE=/tmp/DiskInfo.conf
	TMP_DISK_INFO_FILE=/tmp/DiskInfo.conf~
	DEVICE_NAME=$1
}

function PrintTmpDiskInfo()
{
	echo "========================"
	echo " $1"
	echo "========================"
	echo "cat $TMP_DISK_INFO_FILE"
	cat $TMP_DISK_INFO_FILE
	echo "========================"
	echo ""
}

function CheckDisksInfo ()
{
	rm -f $TMP_DISK_INFO_FILE
	DISKS=`ls -d /sys/block/sd*`
	LOCAL_DISK_NUMBER=0
	EXTERNAL_DISK_NUMBER=0
	TOTAL_DEV_NUM=0
	DISK_GROUP=""
	for DISK in $DISKS
	do
		IS_REMOVABLE=`ls -l $DISK/ | grep usb | wc -l`
		if [ 0 == "$IS_REMOVABLE" ]; then
			((LOCAL_DISK_NUMBER += 1))
			DEV_NAME[$TOTAL_DEV_NUM]="${DISK:11}"
		elif [ 1 == "$IS_REMOVABLE" ]; then
			((EXTERNAL_DISK_NUMBER += 1))
			DEV_NAME[$TOTAL_DEV_NUM]="${DISK:11}"
		fi
		((TOTAL_DEV_NUM += 1))		
	done
	
	if [ "$LOCAL_DISK_NUMBER" -gt 0 ]; then
		echo "LocalDisksCount = $LOCAL_DISK_NUMBER" >> $TMP_DISK_INFO_FILE
	fi
	
	if [ "$EXTERNAL_DISK_NUMBER" -gt 0 ]; then
		echo "ExternalDisksCount = $EXTERNAL_DISK_NUMBER" >> $TMP_DISK_INFO_FILE
	fi
	
	for ((H=0; H<TOTAL_DEV_NUM; H++))
	do
		DISK_GROUP=$DISK_GROUP"${DEV_NAME[$H]} "
	done
	
	echo "DiskGroups = $DISK_GROUP" >> $TMP_DISK_INFO_FILE
}

function CheckType ()
{
#	SIZE=0
#	SIZE=`fdisk -l | grep /dev/${DEV_NAME[$I]}: | awk '{printf $5}'`
#	echo "Size = $SIZE" >> $TMP_DISK_INFO_FILE
	
	IS_TYPE=`ls -l /sys/block/${DEV_NAME[$I]}/ | grep usb | wc -l`
	if [ 0 == "$IS_TYPE" ];	then
		echo "Type = 1"	>> $TMP_DISK_INFO_FILE
	elif [ 1 == "$IS_TYPE" ]; then
		echo "Type = 2" >> $TMP_DISK_INFO_FILE
	fi
}

function CheckDisks ()
{
	DISKS_INFORM=""
	
	if [ 1 == $PARTITION_NUM ]; then
		DISKS_INFORM=$DISKS_INFORM"${DEV_NAME[$I]}"
	else
#	for ((K=1; K<=$PARTITION_NUM-1; K++))
#	do
#		DISKS_INFORM=$DISKS_INFORM"${DEV_NAME[$I]}""$K "
		DISKS_INFORM=`ls -l /sys/block/${DEV_NAME[$I]}/ | grep ${DEV_NAME[$I]} | sed -n 1p | awk '{printf $9}'`
#	done
	fi
	echo "Disks = $DISKS_INFORM" >> $TMP_DISK_INFO_FILE
}

function CheckFileSystem ()
{
	TYPE=""
	
	echo >> $TMP_DISK_INFO_FILE
	for ((I=0; I<TOTAL_DEV_NUM; I++))
	do
		IS_TYPE=`ls -l /sys/block/${DEV_NAME[$I]}/ | grep usb | wc -l`	
		if [ 0 != "$IS_TYPE" ]; then
			echo "[ ${DEV_NAME[$I]} ]" >> $TMP_DISK_INFO_FILE
			CheckType
			PARTITION_NUM=`cat /proc/diskstats | grep ${DEV_NAME[$I]} | wc -l`
			CheckDisks
			if [ 1 == $PARTITION_NUM ]; then
				FDISK_INFO=`/Bin/CheckFs /dev/${DEV_NAME[$I]}`
				SIZE_INFO=`cat /proc/partitions | grep ${DEV_NAME[$I]} | awk '{printf $3}'`
				echo "${DEV_NAME[$I]} = $FDISK_INFO $SIZE_INFO" >> $TMP_DISK_INFO_FILE
			else
				for ((J=1; J<=PARTITION_NUM-1; J++))
				  do
				  #FDISK_INFO=`/Bin/CheckFs /dev/${DEV_NAME[$I]}$J`
				  FDISK_INFO=`/Bin/CheckFs /dev/$DISKS_INFORM`
				  #SIZE_INFO=`cat /proc/partitions | grep ${DEV_NAME[$I]}$J | awk '{printf $3}'`
				  SIZE_INFO=`cat /proc/partitions | grep $DISKS_INFORM | awk '{printf $3}'`
				  #echo "${DEV_NAME[$I]}$J = $FDISK_INFO $SIZE_INFO" >> $TMP_DISK_INFO_FILE
				  echo "$DISKS_INFORM = $FDISK_INFO $SIZE_INFO" >> $TMP_DISK_INFO_FILE
				  #echo "${DEV_NAME[$I]}$J = $FDISK_INFO" >> $TMP_DISK_INFO_FILE
				done
			fi
			echo >> $TMP_DISK_INFO_FILE
		else
			IS_MOUNTED=`cat $DISK_INFO_FILE | grep "${DEV_NAME[$I]}" | wc -l`	
#echo "IS_MOUNTED: $IS_MOUNTED"
#			if [ 0 != "$IS_MOUNTED" ]; then
#				awk 'BEGIN{activeline = 0};BEGIN{Symbol="["};{if($1 == Symbol && activeline == 0)activeline = NR};{if($1 == Symbol && activeline != 0 && NR != activeline)activeline = 0};{if(activeline != 0)print $0}' /tmp/DiskInfo.conf >> $TMP_DISK_INFO_FILE
#			else
				echo "[ ${DEV_NAME[$I]} ]" >> $TMP_DISK_INFO_FILE
				CheckType
				PARTITION_NUM=`cat /proc/diskstats | grep ${DEV_NAME[$I]} | wc -l`
				CheckDisks
				if [ 1 == $PARTITION_NUM ]; then
					FDISK_INFO=`/Bin/CheckFs /dev/${DEV_NAME[$I]}`
					SIZE_INFO=`cat /proc/partitions | grep ${DEV_NAME[$I]} | awk '{printf $3}'`
					echo "${DEV_NAME[$I]} = $FDISK_INFO $SIZE_INFO" >> $TMP_DISK_INFO_FILE
					#echo "${DEV_NAME[$I]} = $FDISK_INFO" >> $TMP_DISK_INFO_FILE
				else
					for ((J=1; J<=PARTITION_NUM-1; J++))
					do
						FDISK_INFO=`/Bin/CheckFs /dev/${DEV_NAME[$I]}$J`
						SIZE_INFO=`cat /proc/partitions | grep ${DEV_NAME[$I]}$J | awk '{printf $3}'`
						echo "${DEV_NAME[$I]}$J = $FDISK_INFO $SIZE_INFO" >> $TMP_DISK_INFO_FILE
						#echo "${DEV_NAME[$I]}$J = $FDISK_INFO" >> $TMP_DISK_INFO_FILE
					done
				fi
				echo >> $TMP_DISK_INFO_FILE		
#			fi
		fi
	done
}

function CheckDiff ()
{
	CUR_CONF=`cat $DISK_INFO_FILE`
	TMP_CONF=`cat $TMP_DISK_INFO_FILE`
	if [ "$CUR_CONF" != "$TMP_CONF" ]
	then
		rm -f $DISK_INFO_FILE
		mv -f $TMP_DISK_INFO_FILE $DISK_INFO_FILE
		sleep 5
		/Bin/EventNotifier localhost 5
	else
		rm -f $TMP_DISK_INFO_FILE
	fi
}

function Main ()
{
	SetEnv

	LOOP_COUNT=0
	while [ 1 ];
	do
		CheckDisksInfo
		CheckFileSystem
		CheckDiff
		
		((LOOP_COUNT += 1))
		if [ ! -z $REPEAT_COUNT ] && [ $LOOP_COUNT -eq "$REPEAT_COUNT" ]
		then
#			echo "REPEAT_COUNT:$REPEAT_COUNT, LOOP_COUNT: $LOOP_COUNT"
			break;
		fi
		sleep 4
	done
}

REPEAT_COUNT=$1
echo "REPEAT_COUNT: $REPEAT_COUNT"
Main
